package performa.form;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.Debug;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import performa.intercom.utils.IntercomUtils;
import performa.orm.CompanyUser;
import performa.orm.Job;
import performa.orm.JobApplication;
import performa.orm.types.ApplicationStatus;


public class BulkUpdateFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest      request         =   submission.getRequest();
        List<JobApplication>    applications    =   ObjstoreUtils.getActioned(request, "IsSelected", process.getTransaction(), JobApplication.REFERENCE_JobApplication);
        Job                     job             =   (Job) request.getAttribute("Job");

        Debug.assertion(job != null, "No job found . Call from " + getClass().getName());

        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In BulkUpdateFP selected application count : ", applications != null ? applications.size() : 0 , " of job ", job);

        if(job.getAppStatusWorkFlow() != null && job.getAppStatusWorkFlow().getApplicationStatus() == ApplicationStatus.SHORTLISTED 
                && job.getNoOfCandidatesApplied() > job.getMaxShortlistApplicants() && applications != null)
        {
            Filter<JobApplication>  filter              =   JobApplication.SearchByAll().andApplicationStatus(new EqualsFilter<>(ApplicationStatus.SHORTLISTED));
            Collection              alreadyShortlisted  =   CollectionFilter.filter(applications, filter);
            int                     totalShortlisted    =   applications.size() - alreadyShortlisted.size() + job.getNoOfCandidatesFor(ApplicationStatus.SHORTLISTED);
          
            BusinessObjectParser.assertFieldCondition(totalShortlisted <= job.getMaxShortlistApplicants() , job , Job.MULTIPLEREFERENCE_JobApplications, "exceedMaxShortlisted");
        }
        
        if(job.getAppStatusWorkFlow() != null)
        {
            for(JobApplication application : applications)
            {
                application.setApplicationStatus(job.getAppStatusWorkFlow().getApplicationStatus());

                LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In BulkUpdateFP Job Application Status successfully changed : ", application );
            }
        }      
        // restarting process as custom attributes needs to be updated to intercom
        completeProcessRestartAndRestoreAttribs(process, request);
        
        SecUser     secUser     =   SecUser.getTXUser(process.getTransaction());
        CompanyUser companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);

        // Update company in intercom
        if(companyUser.getCompany() != null)
        {
            IntercomUtils.updateCompany(companyUser.getCompany());
        }
        
        return super.processForm(process, submission, params);
    }
}
