import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { EnumService } from '../../oneit/services/enum.service';
import { SaveService } from '../../oneit/services/save.service';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { SERVICES } from '../config/constants';
import { JobApplicationModel } from '../../models/job-application.model';

@Injectable()

export class JobService {


    constructor(
        private enumService: EnumService,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private saveService: SaveService
    ) {
    }

    getApplicantTalentJobs(queryParams = {}, assocs = []): Observable<any> {
        return this.searchService.getObjects(SERVICES.APPLICANT_TALENT_JOBS, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

    getApplicantJob(id, assocs = []): Observable<JobApplicationModel> {
        return this.searchService.getObjects(SERVICES.APPLICANT_TALENT_JOBS, 'ByID', {id: id}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs)[0];
                }
            )
    }


    getJobPostedLocation(): Observable<any> {
        return this.enumService.getEnums('JobPostedLocations', true);
    }

    saveApplicantJob(createdObjs, updatedObjs, deleteObjs): Observable<any> {
        return this.saveService.saveObjectsWithDefaultSvc(createdObjs, updatedObjs, deleteObjs);
    }


}
