<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<%
    Job                 job             =   (Job) process.getAttribute("Job");
    AppSortOption       appSortOpt      =   (AppSortOption) getData(request, "SortOption");
    WorkFlowStage       workFlowStage   =   (WorkFlowStage)  getData(request, "WorkFlowStage");
    StageType           stageType       =   (StageType)  getData(request, "StageType"); 
    boolean             isDraft         =   stageType == StageType.INITIAL; 
    ApplicationFilter   appFilter       =   (ApplicationFilter)  getData(request, "ApplicationFilter"); 
    Boolean             showOrderBy     =   getData(request, "ShowOrderBy")!= null ? (Boolean)  getData(request, "ShowOrderBy") : Boolean.FALSE;
    AppView             appView         =   (AppView)  getData(request,"AppView");
    SearchApplicant     searchApplicant =   (SearchApplicant)  getData(request, "SearchApplicant");
    String              applicantsPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS) + "&JobID=" + job.getID();
    List<WorkFlowStage> sortedWorkFlows =   ObjstoreUtils.sort(job.getApplicantStages(), 
                                                        new ObjectTransform[]{WorkFlowStage.pipesWorkFlowStage().toSortOrder()}, 
                                                        new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
    HiringTeam          hiringTeam      =   job.getHiringTeam();
    String              keyName         =   WebUtils.getEnumSetKey(request, searchApplicant, SearchApplicant.FIELD_Filter, AppFilter.FACTORY_AppFilter);
%>

<oneit:dynIncluded>
    <script type="text/javascript">
        $(document).ready(function() 
        {   
            $("[name$='AppWorkFlowStage']").change(function()
            {
                $('.bulk-update').click();
            });
            
            enableBulkEdit();
             
            $(".applicant").change(function() {
                enableBulkEdit();
            });
            
            $("#select_all").on("click",function(){
              
                $('.checkbox-list input:checkbox').not(this).prop('checked', this.checked);
                enableBulkEdit();
            });
            
            Vue.component('treeselect', VueTreeselect.Treeselect)

            new Vue({
              el: '#app',
              data: <%= Utils.getApplicantSortingData(searchApplicant)%>
            });
            
            $(".switch input[type='checkbox']").change(function() {
                $("button[name$='search']").click();
            });
        });
        
        function enableBulkEdit() {
            var disable  =   <%= isDraft %> || $('input[class=applicant]:checked').length === 0;
            $("[name$='AppStatusWorkFlow']").prop("disabled", disable);
        }
        
       $(function(){
            $('.search-icon-btn').click(function () {   
               $('.search-real-btn').click();
            });
            $('.filter-icon-btn').click(function () {   
               $('.search-real-btn').click();
            });
        });
    </script>
    <div class="main-applicants-filter">
        <div class="appli-list-shorting">
            <div class="shorting-dropdown appli-left">
                <span class="appli-order-label">Bulk Update</span>
                <div class="wider-select bullk-app-process">
                    <tagfile:ormsingleasso_select obj="<%= job %>"   assocName="AppWorkFlowStage"  cssClass="form-control app-process" id="AppProcessOption"    
                                                          options="<%= sortedWorkFlows.toArray(new WorkFlowStage[0]) %>"/>
                </div>
                <oneit:button   name="bulkupdate"   value=" "   cssClass="bulk-update"  skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("WorkFlowStage", workFlowStage).mapEntry("Job", job).toMap())
                                                                    .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "WorkFlowStage"})))
                                                                    .mapEntry("Job", job)
                                                                    .toMap() %>" />
            </div> 
            <%
                if(hiringTeam.isFalse(hiringTeam.getOnTrial()))
                {
            %>
                <div class="appli-filter">
                    <ul class="">
                        <li class="lable-appli-shorting">View</li>
                        <li class="<%= (appView == AppView.LIST ? "active" : "" ) + " short-list"%>">
                                <oneit:button   value="List"   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("AppView", AppView.LIST).toMap())
                                                                .toMap() %>"/>
                        </li>
                        <li class="<%= (appView == AppView.GRID ? "active" : "" ) + " grid-list"%>">
                                <oneit:button   value="Grid"   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("AppView", AppView.GRID).toMap())
                                                                .toMap() %>"/>
                        </li>
                        <li class="<%= (appView == AppView.DETAILED_GRID ? "active" : "" ) + " detailed-grid-list"%>">
                                <oneit:button   value="Detailed Grid"   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("AppView", AppView.DETAILED_GRID).toMap())
                                                                .toMap() %>"/>
                        </li>
                    </ul>
                </div>
                <div class="shorting-dropdown application_sorting_bar">
                    <div class="appli-order-label">Search Applicants</div>
                    <oneit:ormInput obj="<%= searchApplicant %>"    type="text" attributeName="Details"    cssClass="form-control search-input"    id="searchText" />
                    <span class="search-icon-btn"></span>
                </div>
                <oneit:button value="Search" name="search" cssClass="btn btn-primary search-real-btn"   style="display:none;"/>
            <%
                    if(showOrderBy)
                    {
            %>
                        <div class="shorting-dropdown">
                            <span class="appli-order-label">order by</span>
                            <select class="form-control"    onChange="location=this.value">
                            <%
                                for (AppSortOption  sortOption : AppSortOption.getAppSortOptionArray())
                                {
                                    String  optionLink  =   applicantsPage + "&AppSortOption=" + sortOption.getName();
                            %>
                                    <option <%= (appSortOpt != null && appSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                        <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                    </option>
                            <%
                                }
                            %>
                            </select>
                        </div>
            <%
                    }
                    
                    if(job.hasDiversityQuestions() || job.showAssessmentCriteriaSection())
                    {
            %>
                        <div class="shorting-dropdown showing">
                            <span class="appli-order-label">Showing</span>
                            <div id="app" style="float:left; width:80%;">
                                <treeselect name="<%= keyName %>"   v-model="value" :multiple="true" :options="options" />
                            </div>
                            <div style="float:right; width:20%;">
                                <span class="filter-icon-btn" ></span>
                            </div>
                        </div>
            <%
                    }
                }
            %>
        </div>
        <div class="checkbox-list select-all pull-left">
            <input type='checkbox' id='select_all' value='select_all' class='norecalc'>
            <label for="select_all" class="select-all-jobs">&nbsp;&nbsp;Select all applicants</label>
        </div>
        <div class="pull-right">
            <label class="show-incomplete pull-left">Show Incomplete</label>
                <label class="switch">
                    <oneit:recalcClass  htmlTag="span"  classScript="searchApplicant.getShowIncomplete() ? 'checkbox checked': 'checkbox unchecked'"    searchApplicant="<%= searchApplicant %>">
                        <oneit:ormInput obj="<%= searchApplicant %>"  attributeName="ShowIncomplete"  type="checkbox"/>
                    </oneit:recalcClass>
                    <div class="slider round"></div>
                </label>
        </div>
    </div>
</oneit:dynIncluded>
