package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.BusinessException;
import performa.orm.*;


public class SelectHiringTeamFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        String              nextPage    =   (String) request.getAttribute("nextPage");

        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside SelectHiringTeamFP for ", companyUser, " selected hiring team : ", companyUser.getSelectedTeam());
        
        request.getSession().setAttribute("SelectedHiringTeam", companyUser.getSelectedTeam());
        
        return new ProcessRedirectResult (nextPage, new String[]{});
    }
}