package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.components.ParticipantInitialisationContext;
import oneit.email.ConfigurableArticleTemplateEmailer;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.InitialisationException;
import oneit.utils.MultiException;
import oneit.utils.StringUtils;
import performa.orm.CompanyUser;
import performa.utils.Utils;


public class ResendVerificationFP extends SaveFP
{
    protected ConfigurableArticleTemplateEmailer  emailer;

    
    @Override
    protected Map validate(SubmissionDetails submission, MultiException exceptions) 
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        SecUser             secUser     =   companyUser.getUser();
        
        if(!companyUser.isLoggedViaSocial())
        {
            BusinessObjectParser.assertFieldCondition(StringUtils.isEmailAddress(secUser.getUserName()), secUser, SecUser.FIELD_Email, "invalid", exceptions, true, request);
            BusinessObjectParser.assertFieldCondition(!Utils.isCompanyUserEmailFound(secUser.getTransaction(), secUser.getUserName(), companyUser), secUser, SecUser.FIELD_UserName, "emailExists", exceptions, true, request);
        }
        else
        {
            BusinessObjectParser.assertFieldCondition(!Utils.isCompanyUserEmailFound(secUser.getTransaction(), secUser.getEmail(), companyUser), secUser, SecUser.FIELD_Email, "emailExists", exceptions, true, request);
        }
        
        return super.validate(submission, exceptions);
    }
    
    
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        
        LogMgr.log(CompanyUser.LOG, LogLevel.PROCESSING1, "Inside ResendVerificationFP resending verification email to company user : ", companyUser);
        
        if(companyUser != null)
        {
            Utils.sendEmailChangedMail(companyUser, request, emailer, ResendVerificationFP.class.getName());
        }
        
        return super.processForm(process, submission, params);
    }
    
    
    @Override
    public void init(ParticipantInitialisationContext context) throws InitialisationException
    {
        super.init(context);
        
        emailer = (ConfigurableArticleTemplateEmailer) (context.getSingleChild("AccountVerificationEmailer"));
    }
}