import { Component } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { CareerProfileModel } from '../../models/career-profile.model';

@Component({
    selector: 'app-profile-tasks',
    templateUrl: './profile-tasks.component.html',
    styleUrls: ['./profile-tasks.component.scss']
})
export class ProfileTasksComponent extends BaseComponent {

    careerProfile = new CareerProfileModel();
    avatarBorder = 'linear-gradient(90deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)';

    constructor(
        private ps: PersonalDetailsService,
        private us: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.us.cloneObject(profile);
                this.setProfileCompletion();
            })
    }

    setProfileCompletion(): void {
        const percentage = (this.careerProfile.CompletedPercentage || 0) * 3.6;
        const degree =  percentage <= 180 ? 90 + percentage : percentage - 90;
        this.avatarBorder = `linear-gradient(${degree}deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
    }

}
