
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CompanyUserHiringTeamLinkPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CompanyUserHiringTeamLinkPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "CompanyUserHiringTeamLink");

    // Private attributes corresponding to business object data
    private RoleType dummyRole;
    

    // Static constants corresponding to attribute helpers
    private static final EnumeratedAttributeHelper HELPER_Role = new EnumeratedAttributeHelper (RoleType.FACTORY_RoleType);
    



    public CompanyUserHiringTeamLinkPersistenceMgr ()
    {
        dummyRole = (RoleType)(HELPER_Role.initialise (dummyRole));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_company_user_hiring_team_link.object_id as id, {PREFIX}tl_company_user_hiring_team_link.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_company_user_hiring_team_link.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_company_user_hiring_team_link.role_type, {PREFIX}tl_company_user_hiring_team_link.hiring_team_id, {PREFIX}tl_company_user_hiring_team_link.company_user_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, CompanyUserHiringTeamLink.REFERENCE_CompanyUserHiringTeamLink);

                if (objectToReturn instanceof CompanyUserHiringTeamLink)
                {
                    LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a CompanyUserHiringTeamLink");
                }
            }

            PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(id, "tl_company_user_hiring_team_link", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_company_user_hiring_team_linkPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_company_user_hiring_team_linkPSet.containsAttrib(CompanyUserHiringTeamLink.FIELD_Role)||
                    !tl_company_user_hiring_team_linkPSet.containsAttrib(CompanyUserHiringTeamLink.SINGLEREFERENCE_HiringTeam)||
                    !tl_company_user_hiring_team_linkPSet.containsAttrib(CompanyUserHiringTeamLink.SINGLEREFERENCE_CompanyUser))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                CompanyUserHiringTeamLink result = new CompanyUserHiringTeamLink ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_company_user_hiring_team_link " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_company_user_hiring_team_link.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (CompanyUserHiringTeamLink.SINGLEREFERENCE_HiringTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_company_user_hiring_team_link " +
                            "WHERE " + SELECT_JOINS + "hiring_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (CompanyUserHiringTeamLink.SINGLEREFERENCE_CompanyUser))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_company_user_hiring_team_link " +
                            "WHERE " + SELECT_JOINS + "company_user_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(objectID, "tl_company_user_hiring_team_link");
            

            
            if (tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_company_user_hiring_team_link " +
                                                           "SET role_type = ?, hiring_team_id = ? , company_user_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_company_user_hiring_team_link.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Role.getForSQL(dummyRole, tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.FIELD_Role))).listEntry (SQLManager.CheckNull((Long)(tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.SINGLEREFERENCE_CompanyUser)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_company_user_hiring_team_link WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_company_user_hiring_team_link", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_company_user_hiring_team_link");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_company_user_hiring_team_link for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_company_user_hiring_team_linkPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(objectID, "tl_company_user_hiring_team_link");
        

        LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_company_user_hiring_team_link " +
                                                       "WHERE tl_company_user_hiring_team_link.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_company_user_hiring_team_link WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_company_user_hiring_team_link");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_company_user_hiring_team_link for row:" + objectID;

                    LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_company_user_hiring_team_linkPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryAllActive (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAllActive");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, CompanyUserHiringTeamLink> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (CompanyUserHiringTeamLink.REFERENCE_CompanyUserHiringTeamLink.getObjectIDSpace (), r.getLong ("id"));
            CompanyUserHiringTeamLink resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, CompanyUserHiringTeamLink.REFERENCE_CompanyUserHiringTeamLink);

                if (cachedElement instanceof CompanyUserHiringTeamLink)
                {
                    LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (CompanyUserHiringTeamLink)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a CompanyUserHiringTeamLink");
                }
            }
            else
            {
                PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(objectID, "tl_company_user_hiring_team_link", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new CompanyUserHiringTeamLink ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CompanyUserHiringTeamLinkPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_company_user_hiring_team_link " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (CompanyUserHiringTeamLink.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_company_user_hiring_team_link.object_id is not null
                    String preFilter = "(tl_company_user_hiring_team_link.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_company_user_hiring_team_link " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (CompanyUserHiringTeamLink.SEARCH_AllActive))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = ", oneit_sec_user_extension ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_company_user_hiring_team_link.object_id is not null and oneit_sec_user_extension.is_disabled != 'Y'
                    String preFilter = "(tl_company_user_hiring_team_link.object_id is not null and oneit_sec_user_extension.is_disabled != 'Y')"
                                     + " AND (oneit_sec_user_extension.object_id = tl_company_user_hiring_team_link.company_user_id)  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_company_user_hiring_team_link " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(objectID, "tl_company_user_hiring_team_link", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_company_user_hiring_team_linkPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_company_user_hiring_team_linkPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_company_user_hiring_team_linkPSet.setAttrib(CompanyUserHiringTeamLink.FIELD_Role, HELPER_Role.getFromRS(dummyRole, r, "role_type"));
        
        tl_company_user_hiring_team_linkPSet.setAttrib(CompanyUserHiringTeamLink.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        tl_company_user_hiring_team_linkPSet.setAttrib(CompanyUserHiringTeamLink.SINGLEREFERENCE_CompanyUser, r.getObject ("company_user_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_company_user_hiring_team_linkPSet = allPSets.getPersistentSet(objectID, "tl_company_user_hiring_team_link");
        

        
        if (tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_company_user_hiring_team_linkPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_company_user_hiring_team_link " +
                                     "  (role_type,  hiring_team_id, company_user_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Role.getForSQL(dummyRole, tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.FIELD_Role))) .listEntry (SQLManager.CheckNull((Long)(tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_company_user_hiring_team_linkPSet.getAttrib (CompanyUserHiringTeamLink.SINGLEREFERENCE_CompanyUser)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_company_user_hiring_team_linkPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
