import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ConfirmDialogModule } from 'primeng/confirmdialog';
import { TableModule } from 'primeng/table';
import { TooltipModule } from 'primeng/tooltip';
import { PrimeNGModules } from '../../utils/common.modules.import';
import { AssessmentService } from '../services/assessment.service';
import { IntroLetterService } from '../services/intro-letter.service';
import { JobService } from '../services/job.service';
import { PersonalDetailsService } from '../services/personal-details.service';
import { ToasterService } from '../services/toaster.service';
import { AssessmentHeaderComponent } from './assessment-header/assessment-header.component';
import { FormControlComponent } from './form-control/form-control.component';
import { GooglePlacesAutocompleteDirective } from './google-places-autocomplete.directive';
import { IconReplacerDirective } from './icon-replacer.directive';
import { OverlayComponent } from './overlay/overlay.component';
import { PersonalDetailsComponent } from './personal-details/personal-details.component';
import { TemplatesComponent } from './templates/templates.component';
import { TruncatePipe } from './truncate.pipe';

const MODULES = [
    ReactiveFormsModule,
    FormsModule,
    ...PrimeNGModules,
    ConfirmDialogModule,
    TooltipModule,
    TableModule
];

const COMPONENTS = [
    FormControlComponent,
    OverlayComponent,
    PersonalDetailsComponent,
    TemplatesComponent,
    AssessmentHeaderComponent
];

const DIRECTIVES = [
    GooglePlacesAutocompleteDirective,
    IconReplacerDirective
];

const PIPES = [
    TruncatePipe
];

@NgModule({
    imports: [
        CommonModule,
        ...MODULES
    ],
    exports: [
        ...MODULES,
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ],
    providers: [
        ToasterService,
        PersonalDetailsService,
        AssessmentService,
        IntroLetterService,
        JobService
    ],
    declarations: [
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ]
})
export class McSharedModule {
}
