import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { JobDetailsComponent } from './job/job-details/job-details.component';
import { JobProfileComponent } from './job/job-profile/job-profile.component';
import { JobsComponent } from './jobs/jobs.component';

const routes: Routes = [
    {
        path: '',
        component: JobsComponent
    },
    {
        path: 'new',
        component: JobDetailsComponent
    },
    {
        path: ':id',
        component: JobDetailsComponent
    },
    {
        path: ':id/profile',
        component: JobProfileComponent
    }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class JobsRouting { }
