import { OnDestroy } from '@angular/core';
import * as moment from 'moment';
import { BaseComponent } from './base.component';

export class AssessmentBaseComponent extends BaseComponent implements OnDestroy {

    autoSaveInterval;
    autoSavedOn;
    autoSaveLabel = 'a few seconds ago';

    setAutoSaveInterval(): void {
        if (!this.autoSaveInterval) {
            this.autoSave();
            setInterval(() => {
                this.autoSave();
            }, 60000);
        }
    }

    autoSave(): void {
        this.autoSaveLabel = moment(this.autoSavedOn).fromNow();
    }

    ngOnDestroy(): void {
        super.ngOnDestroy();
        if (this.autoSaveInterval) {
            clearInterval(this.autoSaveInterval);
        }
    }
}
