import { Component, OnDestroy, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { AssessmentBaseComponent } from '../../base/assessment-base.component';
import { WorkStyleQuestionModel } from '../../models/work-style-question.model';
import { AssessmentService } from '../../services/assessment.service';
import { ToasterService } from '../../services/toaster.service';

@Component({
    selector: 'app-work-style',
    templateUrl: './work-style.component.html',
    styleUrls: ['./work-style.component.scss']
})

export class WorkStyleComponent extends AssessmentBaseComponent implements OnInit, OnDestroy {

    workStyleQuestion = new WorkStyleQuestionModel();
    assocs = ['Question', 'SelectedQuestion'];
    answerScales = [];
    wasUpdated = false;
    isBack = false;
    selectedAns;

    constructor(
        private assessmentService: AssessmentService,
        private utilService: UtilsService,
        private toasterService: ToasterService,
        private router: Router
    ) {
        super();
    }

    ngOnInit(): void {
        this.initiateWorkStyle();
        this.setAutoSaveInterval();
    }

    initiateWorkStyle(previousQuestion = false): void {
        this.isBack = previousQuestion;
        this.isLoading = true;
        this.assessmentService.getWorkStyle(this.assocs, previousQuestion)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.autoSavedOn = new Date();
                this.autoSave();
                if (response.length > 0) {
                    this.workStyleQuestion = response[0];
                    this.selectedAns = this.workStyleQuestion.Answer ? this.workStyleQuestion.Answer : null;
                } else {
                    this.exit();
                }
                this.setAnswerScales();
            }, err => {
                this.isLoading = false;
                this.utilService.handleError(err);
                this.exit();
            });
    }

    setAnswerScales(): void {
        this.answerScales = [];
        setTimeout(() => {
            for (let i = 1; i <= (this.workStyleQuestion.Scalar || 1); i++) {
                this.answerScales.push(i);
            }
        });
    }

    submitAnswer(scale): void {
        this.selectedAns = scale;
        this.isBack = false;
        const formData = {
            Question: this.workStyleQuestion.Question.ObjectID,
            Answer: scale,
            Continue: true
        };
        this.isLoading = true;
        this.assessmentService.saveWorkStyle(formData)
            .subscribe(response => {
                this.selectedAns = null;
                this.isLoading = false;
                this.autoSavedOn = new Date();
                this.autoSave();
                this.wasUpdated = true;
                if (response.NextQuestion) {
                    this.workStyleQuestion = response.NextQuestion;
                    this.setAnswerScales();
                } else {
                    this.exit();
                }
            }, err => {
                this.isLoading = false;
                this.utilService.handleError(err);
            });
    }

    exit(): void {
        this.toasterService.success('Work style updated!');
        this.router.navigate(['/my-career-web/dashboard/home']);
    }

}
