package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.orm.*;
import performa.orm.types.ApplicationStatus;
import performa.utils.AnalysisEngine;
 

public class CompleteApplicationFP extends SaveFP
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException 
    {
        JobApplication  jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        jobApplication.setApplicationStatus(ApplicationStatus.SUBMITTED);
        
        AnalysisEngine.analyseAnswers(jobApplication);
        
        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING2, "Job Application Completed", jobApplication);
        
        return super.processForm(process, submission, params);
    }

    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException 
    {
        HttpServletRequest  request     =   submission.getRequest();
        JobApplication  jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        BusinessObjectParser.assertFieldCondition(jobApplication.getCultureCriteriaAnswersCount()>0, jobApplication, jobApplication.FIELD_ObjectID, "completeCulture", exceptions, true, request);
    
        super.validate(process, submission, exceptions, params);
    }
}