package performa.orm;

import java.util.*;
import oneit.objstore.rdbms.filters.*;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.*;
import oneit.utils.filter.*;
import oneit.utils.parsers.FieldException;
import performa.orm.types.*;


public class AssessmentCriteriaTemplate extends BaseAssessmentCriteriaTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public AssessmentCriteriaTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    

    @Override
    public String getToString() 
    {
        return getTemplateName();
    }
    
    public List<WorkFlowStage> getSortedMiddleWorkFlowStages()
    {
        Filter<WorkFlowStage>    filter  =   WorkFlowStage.SearchByAll().andStageType(new NotInFilter<>(StageType.INITIAL, StageType.UNSUITABLE, StageType.WITHDREW));
        
        return ObjstoreUtils.sort(pipesAssessmentCriteriaTemplate().toWorkFlowTemplate().toWorkFlowStages(filter).uniqueVals(), 
                                new ObjectTransform[]{WorkFlowStage.pipesWorkFlowStage().toSortOrder()}, 
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
    }
    
    public WorkFlowStage getWorkFlowStageBySortOrder(int sortOrder)
    {
        Filter<WorkFlowStage>    filter  =   WorkFlowStage.SearchByAll().andSortOrder(new EqualsFilter<>(sortOrder));
        
        return pipelineAssessmentCriteriaTemplate().toWorkFlowTemplate().toWorkFlowStages(filter).val();
    } 
    
    public String getLevelClass(Level level)
    {
        if(!showLevelOption(level))
        {
            return "hide";
        }
        
        if(CollectionUtils.equals(level, getLevel()))
        {
            return "active";
        }
        return "";
    }
    
    public boolean showLevelOption(Level level)
    {
        if(isExpressJob())
        {
            return isTrue(level.getAppliedToExpress());
        }
        return !isTrue(level.getAppliedToExpress());
    }
    
    public boolean isExpressJob()
    {
        return getAssessmentType() == AssessmentType.EXPRESS;
    }
    
    public boolean showAssessmentCriteriaSection()
    {
        return isTrue(getIncludeAssessmentCriteria());
    }
    
    public Collection<AssessmentCriteria> getAssessmentCriteraByType(CriteriaType criteria)
    {
        Filter  filter  = AssessmentCriteria.SearchByAll().andCriteriaType(new EqualsFilter<>(criteria));   

        return  CollectionFilter.filter(getAssessmentCriteriasSet(), filter);
    }
    
    public int getAssessmentCriteraCountByType(CriteriaType criteria)
    {
        return getAssessmentCriteraByType(criteria).size();
    }
    
    @Override
    protected void postILOJobTitleChange() throws FieldException
    {
        Occupation  occupation  =   getILOJobTitle() != null ? getILOJobTitle().getOccupation() : null;
        
        if(occupation != null)
        {
            setOccupation(occupation);
            setSuggestedAssessmentType(getJobType() == JobType.FULL_TIME ? occupation.getAssessmentType() : occupation.getPartTimeAssessmentType());
            setAssessmentType(getJobType() == JobType.FULL_TIME ? occupation.getAssessmentType() : occupation.getPartTimeAssessmentType());
            setLevel(getAssessmentType() == AssessmentType.COMPREHENSIVE ? occupation.getAssessmentLevel() : occupation.getExpressAssessmentLevel());
        }
        
        super.postILOJobTitleChange(); 
    }

    
    @Override
    protected void postJobTypeChange() throws FieldException 
    {
        Occupation  occupation  =   getILOJobTitle() != null ? getILOJobTitle().getOccupation() : null;

        if(occupation != null)
        {
            setSuggestedAssessmentType(getJobType() == JobType.FULL_TIME ? occupation.getAssessmentType() : occupation.getPartTimeAssessmentType());
            setAssessmentType(getJobType() == JobType.FULL_TIME ? occupation.getAssessmentType() : occupation.getPartTimeAssessmentType());
            setLevel(getAssessmentType() == AssessmentType.COMPREHENSIVE ? occupation.getAssessmentLevel() : occupation.getExpressAssessmentLevel());
        }
        
        super.postJobTypeChange();
    }

    
    @Override
    public AssessmentType getSuggestedAssessmentType() 
    {
        Occupation  occupation  =   getILOJobTitle() != null ? getILOJobTitle().getOccupation() : null;

        if(occupation != null)
        {
            return getJobType() == JobType.FULL_TIME ? occupation.getAssessmentType() : occupation.getPartTimeAssessmentType();
        }
        
        return super.getSuggestedAssessmentType();
    }
    
    @Override
    protected void postAssessmentTypeChange() throws FieldException 
    {
        Occupation  occupation  =   getILOJobTitle() != null ? getILOJobTitle().getOccupation() : null;

        if(occupation != null && getSuggestedAssessmentType() != super.getAssessmentType())
        {
            setLevel(getAssessmentType() == AssessmentType.COMPREHENSIVE ? occupation.getAssessmentLevel() : occupation.getExpressAssessmentLevel());
        }
        
        super.postAssessmentTypeChange(); 
    }
    
    public Occupation displayOccupation()
    {
        return getOccupation();
    }

}