<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         = process.getTransaction ();
    String              currentPage     = WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    String              nextPage        = WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    JobApplication      jobApplication  = (JobApplication) process.getAttribute("JobApplication");
    Job                 job             = jobApplication.getJob();
    int                 questionNumber  = process.getAttribute("QuestionNumber")!= null ? (int) process.getAttribute("QuestionNumber") : 0;
    List<Question>      allQuestions    = (List<Question>) process.getAttribute("AllQuestions");
    
    if(allQuestions==null)
    {
        allQuestions    = job.getAllLeftQuestions();
        
        process.setAttribute("AllQuestions", allQuestions);
    }
    
%>
    <script>
        $(document.body).addClass('bg-color');
    </script>
    
    <div class="main-application-outline">
        <div class="selection-aust-logo">
            <img src="images/australia-post.png" />
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Section 3 - Job Match Assessment</div>
            <div class="mobile-estimated">Estimated time to complete: <b>20 mins</b></div>
        </div>
        <div class="section-title m-hide">Section 3</div>
        <div class="section-c-title m-hide">
            Job Match Assessment
            <span>Estimated time to complete: <b>20 mins</b></span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="3"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area section-job-match">
                    <div class="main-sc-section sj-1">
                        <p>Using the scale given, indicate how important to you are the following aspects in your work life. Use the following system:</p>
                        <ul class="security-level">
                            <li><span>1</span> means of very little importance to you</li>
                            <li><span>4</span> means about average in importance to you</li>
                            <li><span>7</span> means of high importance to you</li>
                        </ul>
                        <p>Use the other numbers (2, 3, 5, 6) to indicate in-between levels of importance to you.</p>            
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section main-rate-section">
                        <%
                            int totNoOfQuestions    = allQuestions.size();
                            
                            if(questionNumber<totNoOfQuestions)
                            {
                                Answer  answer              = jobApplication.getPAAnswerOrCreate(allQuestions.get(questionNumber), questionNumber);
                                Integer selectedAnswerNo    = answer.getAnswerNo();
                        %>
                                <div class="rateing-title">
                                    Rate the importance of each item below
                                    <span><oneit:toString value="<%= (questionNumber + 1) %>"   mode="EscapeHTML"/>/<oneit:toString value="<%= totNoOfQuestions %>"   mode="EscapeHTML"/></span>
                                </div>
                                <div class="rating-box-title">
                                    <oneit:toString value="<%= answer.getQuestion().getDescription() %>"    mode="EscapeHTML"/>
                                </div>
                                <div class="ratting-box">
                                    <span>Very little importance</span>  
                                    <ul class="pagination ratting-number">

                                        <%
                                            for(int index=1; index<=7; index++)
                                            {
                                                String  activeClass = CollectionUtils.equals(index, selectedAnswerNo) ? "active" : "";
                                        %>
                                                <li class="<%= activeClass %>"><a href="#"><oneit:toString  value="<%= index %>"    mode="EscapeHTML"/></a></li>
                                        <%
                                            }
                                        %>
                                        <li><a href="#">1</a></li>
                                        <li><a href="#">2</a></li>
                                        <li><a href="#">3</a></li>
                                        <li><a href="#">4</a></li>
                                        <li class="active"><a href="#">5</a></li>
                                        <li><a href="#">6</a></li>
                                        <li><a href="#">7</a></li>
                                    </ul>
                                    <span>High importance</span>
                                </div>
                        <%
                            }
                        %>
                        <div >
                            <span style="float: left">
                                <%
                                    if(questionNumber>0)
                                    {
                                %>
                                        <oneit:button   value="Previous"    name="gotoPage" cssClass="box-btn-gray" 
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("QuestionNumber", (questionNumber - 1)).toMap())
                                                                                        .toMap() %>"/>
                                <%
                                    }
                                %>
                            </span>
                            <span style="float: right">
                                <%
                                    if((questionNumber+1)<totNoOfQuestions)
                                    {
                                %>
                                        <oneit:button   value="Next"    name="gotoPage" cssClass="box-btn" 
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("QuestionNumber", (questionNumber + 1)).toMap())
                                                                                        .toMap() %>"/>
                                <%
                                    }
                                %>
                            </span>
                        </div>
                        <div class="auto-save">
                            <%
                                if((questionNumber)==totNoOfQuestions)
                                {
                            %>
                                    <oneit:button   value="Complete"    name="gotoPage" cssClass="box-btn" 
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                            <%-- <div>Autosaved 1 min ago.</div> --%>
                        </div>
                    </div>                      
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>