<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");

    SecUser     secUser     =   SecUser.getTXUser(transaction);
    
    Debug.assertion(secUser != null, "Invalid candidate in applicant portal");
    
    Candidate   candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);

    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");

    String          successPage     =   WebUtils.getSamePageInRenderMode(request, "VerifyIdentity") + "&JobID=" + job.getID();
    JobApplication  jobApplication  =   JobApplication.searchCandidateJob(transaction, candidate, job);

    jobApplication.setIsEmailIngest(true);
    process.setAttribute("JobApplication", jobApplication);
%>
    <oneit:script>
        <oneit:script src="/scripts/password_strength_lightweight.js"/>
    </oneit:script>   
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
        
        .email input[name$="Email"] {
            opacity: 0;
            position: absolute;
        }
    </style>
    
    <script type="text/javascript">
        $(document.body).addClass('bg-color');
        var  interval ;
        $(document).ready(function() {
            recalcFunction = setupRecalc ($("form#signIn"), {'recalcOnError':true});
            interval =  setInterval(function() { validate(); }, 500);
            validate();
            $('input').on('change keyup', function() { validate(); });
        });

        function validate() {
            var empty = false;
            $('input[required]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                    if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                       empty = false;
                    }
                }
            });

            if (empty) {
                $('.verify-btn').attr('disabled', 'disabled');
            } else {
                $('.verify-btn').removeAttr('disabled');
                 clearInterval(interval);
            }
        }
    </script>
    <oneit:form name="signIn" method="post" enctype="multipart/form-data">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="apply-job-logo-header signinpage">
             <div class="box-sizing-border-box">
                <div class="logo-img">
                <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                </div>
                <div class="header-title">
                    <%= job.getTeamName() %>
                </div>
            </div>
        </div>
        <div class="main-verify-identity">
            <div class="pl-confirm text-center">Please confirm your details to continue</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Email Address</label>
                    <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="Email"   cssClass="form-control"    style="text-transform: lowercase"    required="true"/>
                </div>
                <div class="row">
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="FirstName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="FirstName"   cssClass="form-control second-style"    required="true"/>
                    </div>
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="LastName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="LastName"    cssClass="form-control second-style"    required="true"/>
                    </div>
                </div>
                <oneit:recalcClass  htmlTag="div"   classScript="candidate.isEmailFound() ? 'show': 'hide'"  candidate="<%= candidate %>" id="password-fileds">
                    <div class="form-group text-left">
                        <label>Password</label>
                        <input type="password"  class="form-control"    name="password" required>
                    </div>
                </oneit:recalcClass>
                <div class="text-center">
                    <oneit:button   value="Submit"   name="identifyUser"    cssClass="box-btn send-link-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", successPage)
                                                                        .mapEntry("Job",job)
                                                                        .mapEntry("Candidate",candidate)
                                                                        .mapEntry("JobApplication",jobApplication)
                                                                        .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                        .toMap() %>"/>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
