
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class ClassNormalisationPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea ClassNormalisationPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "ClassNormalisation");

    // Private attributes corresponding to business object data
    private FactorClass dummyFactorClass;
    private Double dummyMeanScore;
    private Double dummyMaxScore;
    private Double dummyMinScore;
    private Double dummyStddevScore;
    private Double dummyLeftMeanScore;
    private Double dummyRightMeanScore;
    private Double dummyWghtMeanScore;
    private Double dummyWghtStddevScore;
    private Double dummyWghtLeftMeanScore;
    private Double dummyWghtRightMeanScore;
    

    // Static constants corresponding to attribute helpers
    private static final EnumeratedAttributeHelper HELPER_FactorClass = new EnumeratedAttributeHelper (FactorClass.FACTORY_FactorClass);
    private static final DefaultAttributeHelper HELPER_MeanScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MaxScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MinScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StddevScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LeftMeanScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_RightMeanScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtMeanScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtStddevScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtLeftMeanScore = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_WghtRightMeanScore = DefaultAttributeHelper.INSTANCE;
    



    public ClassNormalisationPersistenceMgr ()
    {
        dummyFactorClass = (FactorClass)(HELPER_FactorClass.initialise (dummyFactorClass));
        dummyMeanScore = (Double)(HELPER_MeanScore.initialise (dummyMeanScore));
        dummyMaxScore = (Double)(HELPER_MaxScore.initialise (dummyMaxScore));
        dummyMinScore = (Double)(HELPER_MinScore.initialise (dummyMinScore));
        dummyStddevScore = (Double)(HELPER_StddevScore.initialise (dummyStddevScore));
        dummyLeftMeanScore = (Double)(HELPER_LeftMeanScore.initialise (dummyLeftMeanScore));
        dummyRightMeanScore = (Double)(HELPER_RightMeanScore.initialise (dummyRightMeanScore));
        dummyWghtMeanScore = (Double)(HELPER_WghtMeanScore.initialise (dummyWghtMeanScore));
        dummyWghtStddevScore = (Double)(HELPER_WghtStddevScore.initialise (dummyWghtStddevScore));
        dummyWghtLeftMeanScore = (Double)(HELPER_WghtLeftMeanScore.initialise (dummyWghtLeftMeanScore));
        dummyWghtRightMeanScore = (Double)(HELPER_WghtRightMeanScore.initialise (dummyWghtRightMeanScore));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_class_norm.object_id as id, {PREFIX}tl_class_norm.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_class_norm.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_class_norm.class_code, {PREFIX}tl_class_norm.mean_score, {PREFIX}tl_class_norm.max_score, {PREFIX}tl_class_norm.min_score, {PREFIX}tl_class_norm.stddev_score, {PREFIX}tl_class_norm.left_mean_score, {PREFIX}tl_class_norm.right_mean_score, {PREFIX}tl_class_norm.wght_mean_score, {PREFIX}tl_class_norm.wght_stddev_score, {PREFIX}tl_class_norm.wght_left_mean_score, {PREFIX}tl_class_norm.wght_right_mean_score, {PREFIX}tl_class_norm.level_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, ClassNormalisation.REFERENCE_ClassNormalisation);

                if (objectToReturn instanceof ClassNormalisation)
                {
                    LogMgr.log (ClassNormalisationPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a ClassNormalisation");
                }
            }

            PersistentSet tl_class_normPSet = allPSets.getPersistentSet(id, "tl_class_norm", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_class_normPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_FactorClass)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_MeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_MaxScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_MinScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_StddevScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_LeftMeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_RightMeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_WghtMeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_WghtStddevScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_WghtLeftMeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.FIELD_WghtRightMeanScore)||
                    !tl_class_normPSet.containsAttrib(ClassNormalisation.SINGLEREFERENCE_Level))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (ClassNormalisationPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                ClassNormalisation result = new ClassNormalisation ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_class_norm " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_class_norm.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (ClassNormalisation.SINGLEREFERENCE_Level))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_class_norm " +
                            "WHERE " + SELECT_JOINS + "level_number = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_class_normPSet = allPSets.getPersistentSet(objectID, "tl_class_norm");
            

            
            if (tl_class_normPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_class_normPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_class_norm " +
                                                           "SET class_code = ?, mean_score = ?, max_score = ?, min_score = ?, stddev_score = ?, left_mean_score = ?, right_mean_score = ?, wght_mean_score = ?, wght_stddev_score = ?, wght_left_mean_score = ?, wght_right_mean_score = ?, level_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_class_norm.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_FactorClass.getForSQL(dummyFactorClass, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_FactorClass))).listEntry (HELPER_MeanScore.getForSQL(dummyMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MeanScore))).listEntry (HELPER_MaxScore.getForSQL(dummyMaxScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MaxScore))).listEntry (HELPER_MinScore.getForSQL(dummyMinScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MinScore))).listEntry (HELPER_StddevScore.getForSQL(dummyStddevScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_StddevScore))).listEntry (HELPER_LeftMeanScore.getForSQL(dummyLeftMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_LeftMeanScore))).listEntry (HELPER_RightMeanScore.getForSQL(dummyRightMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_RightMeanScore))).listEntry (HELPER_WghtMeanScore.getForSQL(dummyWghtMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtMeanScore))).listEntry (HELPER_WghtStddevScore.getForSQL(dummyWghtStddevScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtStddevScore))).listEntry (HELPER_WghtLeftMeanScore.getForSQL(dummyWghtLeftMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtLeftMeanScore))).listEntry (HELPER_WghtRightMeanScore.getForSQL(dummyWghtRightMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtRightMeanScore))).listEntry (SQLManager.CheckNull((Long)(tl_class_normPSet.getAttrib (ClassNormalisation.SINGLEREFERENCE_Level)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_class_norm WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_class_norm", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (ClassNormalisationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_class_norm");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_class_norm for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (ClassNormalisationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_class_normPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (ClassNormalisationPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_class_normPSet = allPSets.getPersistentSet(objectID, "tl_class_norm");
        

        LogMgr.log (ClassNormalisationPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_class_normPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_class_normPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_class_norm " +
                                                       "WHERE tl_class_norm.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_class_norm WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_class_norm");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_class_norm for row:" + objectID;

                    LogMgr.log (ClassNormalisationPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_class_normPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, ClassNormalisation> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (ClassNormalisation.REFERENCE_ClassNormalisation.getObjectIDSpace (), r.getLong ("id"));
            ClassNormalisation resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, ClassNormalisation.REFERENCE_ClassNormalisation);

                if (cachedElement instanceof ClassNormalisation)
                {
                    LogMgr.log (ClassNormalisationPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (ClassNormalisation)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a ClassNormalisation");
                }
            }
            else
            {
                PersistentSet tl_class_normPSet = allPSets.getPersistentSet(objectID, "tl_class_norm", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new ClassNormalisation ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (ClassNormalisationPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_class_norm " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (ClassNormalisation.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_class_norm.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_class_norm.object_id is not null
                    String preFilter = "(tl_class_norm.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_class_norm " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_class_normPSet = allPSets.getPersistentSet(objectID, "tl_class_norm", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_class_normPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_class_normPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_FactorClass, HELPER_FactorClass.getFromRS(dummyFactorClass, r, "class_code"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_MeanScore, HELPER_MeanScore.getFromRS(dummyMeanScore, r, "mean_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_MaxScore, HELPER_MaxScore.getFromRS(dummyMaxScore, r, "max_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_MinScore, HELPER_MinScore.getFromRS(dummyMinScore, r, "min_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_StddevScore, HELPER_StddevScore.getFromRS(dummyStddevScore, r, "stddev_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_LeftMeanScore, HELPER_LeftMeanScore.getFromRS(dummyLeftMeanScore, r, "left_mean_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_RightMeanScore, HELPER_RightMeanScore.getFromRS(dummyRightMeanScore, r, "right_mean_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_WghtMeanScore, HELPER_WghtMeanScore.getFromRS(dummyWghtMeanScore, r, "wght_mean_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_WghtStddevScore, HELPER_WghtStddevScore.getFromRS(dummyWghtStddevScore, r, "wght_stddev_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_WghtLeftMeanScore, HELPER_WghtLeftMeanScore.getFromRS(dummyWghtLeftMeanScore, r, "wght_left_mean_score"));
        tl_class_normPSet.setAttrib(ClassNormalisation.FIELD_WghtRightMeanScore, HELPER_WghtRightMeanScore.getFromRS(dummyWghtRightMeanScore, r, "wght_right_mean_score"));
        
        tl_class_normPSet.setAttrib(ClassNormalisation.SINGLEREFERENCE_Level, r.getObject ("level_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_class_normPSet = allPSets.getPersistentSet(objectID, "tl_class_norm");
        

        
        if (tl_class_normPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_class_normPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_class_norm " +
                                     "  (class_code, mean_score, max_score, min_score, stddev_score, left_mean_score, right_mean_score, wght_mean_score, wght_stddev_score, wght_left_mean_score, wght_right_mean_score,  level_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_FactorClass.getForSQL(dummyFactorClass, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_FactorClass))).listEntry (HELPER_MeanScore.getForSQL(dummyMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MeanScore))).listEntry (HELPER_MaxScore.getForSQL(dummyMaxScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MaxScore))).listEntry (HELPER_MinScore.getForSQL(dummyMinScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_MinScore))).listEntry (HELPER_StddevScore.getForSQL(dummyStddevScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_StddevScore))).listEntry (HELPER_LeftMeanScore.getForSQL(dummyLeftMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_LeftMeanScore))).listEntry (HELPER_RightMeanScore.getForSQL(dummyRightMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_RightMeanScore))).listEntry (HELPER_WghtMeanScore.getForSQL(dummyWghtMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtMeanScore))).listEntry (HELPER_WghtStddevScore.getForSQL(dummyWghtStddevScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtStddevScore))).listEntry (HELPER_WghtLeftMeanScore.getForSQL(dummyWghtLeftMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtLeftMeanScore))).listEntry (HELPER_WghtRightMeanScore.getForSQL(dummyWghtRightMeanScore, tl_class_normPSet.getAttrib (ClassNormalisation.FIELD_WghtRightMeanScore))) .listEntry (SQLManager.CheckNull((Long)(tl_class_normPSet.getAttrib (ClassNormalisation.SINGLEREFERENCE_Level)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_class_normPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
