package performa.orm;

import java.util.*;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.rdbms.filters.*;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.*;
import oneit.utils.filter.*;
import performa.orm.types.FactorClass;


public class Level extends BaseLevel
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public Level ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    @Override
    public String getObjectIDSpace()
    {
        return "Level";
    }

    @Override
    public String getToString() 
    {
        return getLevelDescription();
    }
    
    public LevelFactorType getLevelFactorType(Factor factor)
    {
        Filter<LevelFactorType> levelFactorFilter   =   LevelFactorType.SearchByAll().andFactor(new EqualsFilter(factor));
                    
        return pipelineLevel().toLevelFactorTypes(levelFactorFilter).val();
    }
    
    public ClassNormalisation getClassNormalisationFor(FactorClass factorClass)
    {
        Filter<ClassNormalisation> classNormalisationFilter =   ClassNormalisation.SearchByAll().andFactorClass(new EqualsFilter(factorClass));
                    
        return pipelineLevel().toClassNormalisations(classNormalisationFilter).val();
    }
    
    public LevelNormalisation getLevelNormalisation()
    {
        return pipelineLevel().toLevelNormalisations().val();
    }
    
    public List<FactorLevelLink> getSortedFactorLinks(FactorClass factorClass)
    {
        Filter<FactorLevelLink> factorLevelLinkFilter   =   FactorLevelLink.SearchByAll().andFactorClass(new EqualsFilter(factorClass));
        List<FactorLevelLink>   factorLevelLinksForClass=   (List<FactorLevelLink>) CollectionFilter.filter(getFactorsSet(), factorLevelLinkFilter);
        
        return ObjstoreUtils.sort(factorLevelLinksForClass, 
                                new ObjectTransform[]{FactorLevelLink.pipesFactorLevelLink().toFactor().toObjectID()}, 
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR});
    }
    
    public List<FactorScoreResult> getSortedFactorScoreResults(Factor factor)
    {
        Filter<FactorScoreResult> factorScoreResultFilter   =   FactorScoreResult.SearchByAll().andFactor(new EqualsFilter(factor));
        List<FactorScoreResult>   factorScoreResultsForClass=   (List<FactorScoreResult>) CollectionFilter.filter(getResultsSet(), factorScoreResultFilter);
        
        return ObjstoreUtils.sort(factorScoreResultsForClass, 
                                new ObjectTransform[]{FactorScoreResult.pipesFactorScoreResult().toFromScore()}, 
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR});
    }
    
    public static Level[] getAllLevels(ObjectTransaction objTran)
    {
        return Level.SearchByAll().andEnabled(new EqualsFilter(Boolean.TRUE)).search(objTran);
    }
}