import {browser, by, element, ElementFinder, WebElementPromise} from 'protractor';
import {CreateJobPage} from "./createjob.po";

export class AdminHomePage {
    createJobBtn:ElementFinder;
    createJobIframe:ElementFinder;
    constructor(){
    }

    async clickCreateJobBtn():Promise<CreateJobPage>{
        
        await this.waitTillIframeLoads();
        for(let i=0;i<10;i++){
            try{
                console.log("trying move to iframe 0. retry "+i);
                let myIframe = await element.all(by.tagName("iframe")).get(0).getWebElement();
                await browser.switchTo().frame(myIframe);
                console.log("moved to iframe 0. retry "+i);

                console.log("trying to find  d-create-job-btn. retry "+i);
                this.createJobBtn =  await element(by.css('a[class~="d-create-job-btn"]'));
                console.log("found  d-create-job-btn. retry "+i);


                console.log("trying to click d-create-job-btn. retry "+i);
                await this.createJobBtn.click();
                console.log("clicked d-create-job-btn. retry "+i);

                break;
            }catch(e){
                console.log("err");
                console.log(e);
                await browser.sleep(1000);
            }
            console.log("retry "+ i);
            await browser.sleep(1000);
        }
        
        // await browser.sleep(10000);
        return new Promise<CreateJobPage>(resolve => resolve(new CreateJobPage()));
    }
    async waitTillIframeLoads(){
        for(let i =0 ; i<10 ;i++){
            try{
                console.log("trying to load Iframe. retry "+i);
                await element(by.tagName("iframe")).getWebElement();
                console.log("Iframe loaded");
                break;
              
            }catch(e){
                console.log("err");
                await browser.sleep(1000);
            }
            console.log("retry "+ i);
            await browser.sleep(1000);
        }
    }
}