package performa.form;

import com.stripe.model.Coupon;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.HiringTeam;
import performa.utils.StripeUtils;


public class ApplyCouponFP  extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        HiringTeam          hiringTeam  =   (HiringTeam) request.getAttribute("HiringTeam");

        LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "Inside ApplyCouponFP for ", hiringTeam );

        Coupon coupon   =   StripeUtils.retrieveCoupon(hiringTeam.getCouponCode());
        
        System.out.println("coupon : " + coupon);
        
        return RedisplayResult.getInstance();
    }
}