<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB) + "&fromJob=true";
    String  firstPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATE_JOB);
    String  secondPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);
    String  thirdPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE);
    String  fourthPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_MATCH);
    String  fifthPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_REVIEW);
    String  jobsPage    =   WebUtils.getSamePageInRenderMode(request, "Page");

    if(job == null && request.getParameter("JobID")!= null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }

    Debug.assertion(job != null, "Job is null in admin portal create job");
%>
    <oneit:form name="editJob" method="post" enctype="multipart/form-data">

        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <h1 class="page-title review-title">Review Job</h1>
            
            <div class="page-subtitle-">
                <span class="pull-right plan-link"> Post multiple jobs per month? <a href="#">See our plans</a></span>
            </div>
            
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="5"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="form-page-area">
                <div class="create-job">
                  <div class="assessment-criteria">
                    <div class="form-group">
                        <label class="label-16">Details</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", firstPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>              
                    <div class="form-group">
                        <div class="review-medium-title">
                            <oneit:label GUIName="Job Title" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="review-medium-title">
                            <oneit:label GUIName="Job Description" />
                            <span class="skill-label">
                                <oneit:toString value="<%= job.getJobDescription() %>"  mode="ParagraphHTML" />
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row main-review-label">
                            <div class="col-sm-3 col-xs-12 review-label">
                                <oneit:label GUIName="Job Type" />
                            </div>
                            <div class="col-sm-9 col-xs-12 review-data">
                                <oneit:toString value="<%= job.getJobType() %>" mode="EscapeHTML" />
                            </div>
                        </div>
                        <%
                            SecUser     txUser      =   SecUser.getTXUser(process.getTransaction());
                            CompanyUser companyUser =   txUser.getExtension(CompanyUser.REFERENCE_CompanyUser);

                            if(companyUser.getCompany().showHasClientSupport())
                            {
                        %>
                                <div class="row main-review-label">
                                    <div class="col-sm-3 col-xs-12 review-label">
                                        <oneit:label GUIName="Client" />
                                    </div>
                                    <div class="col-sm-9 col-xs-12 review-data">
                                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                                    </div>
                                </div>
                        <%
                            }
                        %>
                        <div class="row main-review-label">
                            <div class="col-sm-3 col-xs-12 review-label">
                                <oneit:ormlabel  obj="<%= job %>"    field="ReferenceNumber" />
                            </div>
                            <div class="col-sm-9 col-xs-12 review-data">
                                <oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />
                            </div>
                        </div>
                    </div>
                    <div class="form-brack-line-sub"></div>
                    
                    <div class="form-group">
                        <label class="label-16">Role</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", fourthPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                        
                    </div>
                    <div class="form-group">              
                        <div class="row main-review-label">
                            <div class="col-sm-3 col-xs-12 review-label">
                                <oneit:label GUIName="Role Type" />
                            </div>
                            <div class="col-sm-9 col-xs-12 review-data">
                                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
                            </div>
                        </div>
                        <div class="beloning job-match-ass">
                            <oneit:toString value="<%= job.getAssessmentType().getTestDescr() %>" mode="EscapeHTML"/> <oneit:toString value="<%= job.getAssessmentType().getQuestionDetails() %>" mode="EscapeHTML"/> 
                        </div>
                    </div>
                    <div class="form-brack-line-sub"></div>
                    
                    <div class="form-group">
                        <label class="label-16">Culture</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", thirdPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>
                    <div class="form-group">
                        <div class="row main-review-label">
                            <div class="col-sm-3 col-xs-12 review-label">
                                <label><oneit:label GUIName="Location" /></label>
                            </div>
                            <div class="col-sm-9 col-xs-12 review-data">
                                <oneit:toString value="<%= job.getLocation() %>" mode="EscapeHTML"/> 
                            </div>
                        </div>
                    </div>
                    <%
                        for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                        {
                    %>
                            <div class="form-group">
                                <div class="beloning">
                                    <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                </div>
                            </div>

                            <div class="form-group">
                            <%
                                for (CultureCriteria criteria : job.getCultureCriteriasForClass(cultureClass))
                                {
                            %>
                                    <div class="row main-review-label">
                                        <div class="col-sm-3 col-xs-12 review-label culture-element">
                                            <oneit:toString value="<%= criteria.getCultureElement() %>" mode="EscapeHTML"/> 
                                        </div>
                                        <div class="col-sm-9 col-xs-12 review-data">
                                            <oneit:toString value="<%= criteria.getCultureElementRating()!= null ? criteria.getCultureElementRating().getDescription() : ""%>" mode="EscapeHTML"/> 
                                            (<oneit:toString value="<%= criteria.getImportance() %>" mode="EscapeHTML"/>)
                                        </div>
                                    </div>
                            <%  }    %>
                            </div>
                    <%  }   %>
                    <div class="form-brack-line-sub"></div>
                    
                    <div class="form-group">
                        <label class="label-16">Requirements</label>
                        <oneit:button   value="EDIT"   name="gotoPage" cssClass="add-more-btn review-edit-btn pull-right"   skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", secondPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .toMap() %>"/>
                    </div>
                    <%
                        for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                        {
                            Collection<AssessmentCriteria>  assessmentCriterias =   job.getAssessmentCriteraByType(criteria);

                            if(assessmentCriterias.size() == 0)
                            {
                                continue;
                            }
                    %>
                            <div class="form-group">
                                <div class="beloning">
                                    <oneit:toString value="<%= criteria.getName() %>" mode="EscapeHTML"/>
                                </div>
                            </div>
                            <div class="form-group">
                    <%
                            for (AssessmentCriteria assessmentCriteria : assessmentCriterias)
                            {
                    %>
                                <span class="skill-label">
                                    <oneit:toString value="<%= assessmentCriteria.getName() %>" mode="EscapeHTML"/> - 
                                    <oneit:toString value="<%= assessmentCriteria.getImportance() %>" mode="EscapeHTML"/>
                                </span>
                    <%      }    %>
                            </div>
                    <%  }   %>
                    
                    <div class="text-center">
                        <oneit:button   value="Save as Draft and go to your jobs"   name="saveJob"  cssClass="btn  btn-primary btn-gray largeBtn"   
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                        .toMap() %>" />
                        
                        <oneit:button   value="Open this job"   name="saveJob" cssClass="btn btn-primary btn-green top-margin-25 largeBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry ("fromPage", fifthPage)
                                                                        .mapEntry ("openJob", Boolean.TRUE)
                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("Job"))
                                                                        .toMap() %>" />
                    </div>
                  </div>
                </div>
            </div>
        </div>    
    </oneit:form>
</oneit:dynIncluded>