<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>
<%@ page import="oneit.utils.filter.*"%>

<oneit:dynIncluded>
<%
    Job job =   (Job) process.getAttribute("Job");

    if(job == null && request.getParameter("JobID") != null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Debug.assertion(job != null, "Job is null in admin portal view applicants");
    
    String              currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String              applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    AppSortOption       appSortOpt      =   (AppSortOption) process.getAttribute("AppSortOption");
    int                 tabNumber       =   process.getAttribute("TabNumber") != null ? (int) process.getAttribute("TabNumber") : 2;
    SearchApplicant     searchApplicant =   (SearchApplicant) RunSearchExecutorFP.setupExecutor(request, SearchApplicant.REFERENCE_SearchApplicant, true);
    JobApplication[]    applications    =   (JobApplication[]) process.getAttribute("JobApplications");    
    WorkFlow            workflow        =   job.getWorkFlowBySortOrder(tabNumber);

    searchApplicant.setJob(job);

    if(applications == null)
    {
        applications    =   (JobApplication[]) searchApplicant.doSearch();
    }

    if (getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS) != null)
    {
        applications = (JobApplication[])getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS);
    }

    process.setAttribute("JobApplications", applications);

    if(request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    
    if(appSortOpt == null)
    {
        appSortOpt  =   AppSortOption.RANK;
    }
                
    List<JobApplication>    applicantList   =   Arrays.asList(applications);

    // filter applicants by workflow
    oneit.utils.filter.Filter<JobApplication>  filter  =   JobApplication.SearchByAll().andApplicationStatus(new EqualsFilter<>(workflow.getApplicationStatus()));

    applicantList =   new ArrayList<>(CollectionFilter.filter(applicantList, filter));

    List<JobApplication>    sortedApplications  =   Utils.getApplicationsSorted(applicantList, appSortOpt);
    
    process.setAttribute("AppSortOption", appSortOpt);
    process.setAttribute("TabNumber", tabNumber);
%>

    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">
        
        <div class="dashboard-content-area">
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  
                                TabNumber="<%= tabNumber %>"   
                                data="<%= CollectionUtils.EMPTY_MAP%>"/>

            
            <div class="second-part view-app-area">
                <oneit:dynInclude   page="/extensions/adminportal/inc/application_sorting_bar.jsp"  
                                    tabNumber="1"
                                    sortOption="<%= appSortOpt %>"
                                    currentPage="<%= currentPage %>"
                                    showOrderBy="<%= sortedApplications.size() > 1 %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <oneit:dynInclude   page="/extensions/adminportal/inc/application_list_data.jsp"  
                                    applications="<%= sortedApplications %>"
                                    currentPage="<%= currentPage %>"
                                    TabNumber="<%= tabNumber %>"   
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>