package performa.utils;

import oneit.utils.FormatterFactory;
import performa.orm.Job;
import performa.orm.types.AssessmentType;


public class AssessmentTypeEnumFormatter implements FormatterFactory
{
    private Job job;
    
    public AssessmentTypeEnumFormatter(Job job)
    {
        this.job = job;
    }
    
    @Override
    public Object getFormatterFor(Object objectToFormat)
    {
        AssessmentType  assessmentType  =   ((AssessmentType) objectToFormat);
        
        if(job.getSuggestedAssessmentType() == assessmentType)
        {
            return assessmentType.getDescription() +  " (Suggested)";
        }
        
        return assessmentType.getDescription();
    }
}