
-- DROP TABLE tl_hiring_team;




CREATE TABLE tl_hiring_team (
    object_id number(12) NOT NULL ,
    object_last_updated_date date DEFAULT SYSDATE NOT NULL ,
    object_created_date date DEFAULT SYSDATE NOT NULL
    ,
    hiring_team_name varchar2(100) NOT NULL,
    hiring_team_logo blob NULL,
    hiring_team_type varchar2(200) NULL,
    industry varchar2(200) NULL,
    time_zone varchar2(200) NULL,
    state varchar2(200) NULL,
    country varchar2(200) NULL,
    post_code varchar2(10) NULL,
    city varchar2(100) NULL,
    has_client_support char(1) NULL,
    manage_own_billing char(1) NULL,
    stripe_reference varchar2(100) NULL,
    stripe_subscription varchar2(100) NULL,
    stripe_fixed_sub_item varchar2(100) NULL,
    stripe_metered_sub_item varchar2(100) NULL,
    name_on_card varchar2(100) NULL,
    card_post_code varchar2(10) NULL,
    card_id varchar2(100) NULL,
    plan_renewed_on date NULL,
    used_credits number(12) NULL,
    available_credits number(12) NULL,
    is_ppj char(1) NULL,
    has_cap char(1) NULL,
    max_cap number(12) NULL,
    coupon_expiry_date date NULL,
    last_plan_amount number(20,5) NULL,
    google_address_text varchar2(300) NULL,
    plan_cancelled char(1) NULL,
    company_id number(12)  NOT NULL,
    billing_team_id number(12)  NULL,
    added_by_user_id number(12)  NOT NULL,
    payment_plan_id number(12)  NULL,
    coupon_id number(12)  NULL
    );



ALTER TABLE tl_hiring_team ADD    
    CONSTRAINT PK_tl_hiring_team PRIMARY KEY 
    (
        object_id
    ) ;
    
    
    
    CREATE INDEX idx_tl_hiring_team_company_id 
    ON tl_hiring_team (company_id);

    CREATE INDEX idx_tl_hiring_team_billing_team_id 
    ON tl_hiring_team (billing_team_id);
