package performa.utils;

import java.util.*;
import oneit.objstore.ObjectTransaction;
import oneit.security.*;
import oneit.utils.ObjectTransform;
import oneit.utils.Tuple;
import performa.orm.*;
import performa.orm.types.Importance;

/**
 *
 * @author Harsh
 */
public class Utils
{
    public static final String  ROLE_APPLICANT                  =   "TL_Applicant";
    public static final String  ROLE_CLIENT                     =   "TL_Client";
    public static final String  PRIV_ACCESS_ADMIN_PORTAL        =   "TL_AccessAdminPortal";
    public static final String  PRIV_ACCESS_APPLICANT_PORTAL    =   "TL_AccessApplicantPortal";
    public static final String  LEVEL_GENERAL_PURPOSE           =   "General Workforce";
    public static final String  LEVEL_SALES                     =   "Sales Personnel";
    public static final String  LEVEL_MANAGEMENT                =   "Management";
    public static final String  LEVEL_EXECUTIVE                 =   "Executive Management";
    
    public static Role  getRole(String role, ObjectTransaction transaction)
    {
        return Role.SearchByNAME().byName(role).search(transaction);
    }
    
    public static Privilege  getPrivilege(String priv, ObjectTransaction transaction)
    {
        return Privilege.searchNAME(transaction, priv);
    }
    
    public static boolean checkAdminPortalAccess(SecUser secUser)
    {
        return (secUser != null && secUser.hasPrivilege(PRIV_ACCESS_ADMIN_PORTAL));
    }
    
    public static boolean checkApplicantPortalAccess(SecUser secUser)
    {
        return (secUser != null && secUser.hasPrivilege(PRIV_ACCESS_APPLICANT_PORTAL));
    }
    
    public static Candidate getCandidateUser (ObjectTransaction objTran)
    {
        return  SecUser.getTXUser(objTran).getExtension(Candidate.REFERENCE_Candidate);
    }
    
    public static Importance[] getImportancesForAssessment()
    {
        List<Importance>    importances =   new ArrayList<>();
        
        for(Importance importance : Importance.getImportanceArray())
        {
            if(importance.getConsiderForAssessment())
            {
                importances.add(importance);
            }
        }
        return importances.toArray(new Importance[0]);
    }
    
    // TODO: Levels hardcoded for this phase, needs to be changed later!
    public static List<Tuple.T3> getLevelsForComprehensive(ObjectTransaction objTran)
    {
        List<Tuple.T3>  levels  =   new ArrayList();
        
        levels.add(new Tuple.T3(Level.searchName(objTran, LEVEL_GENERAL_PURPOSE), "General Purpose", "gn-pu"));
        levels.add(new Tuple.T3(Level.searchName(objTran, LEVEL_SALES), "Sales", "sales-pic"));
        levels.add(new Tuple.T3(Level.searchName(objTran, LEVEL_MANAGEMENT), "Management", "manag-pic"));
        levels.add(new Tuple.T3(Level.searchName(objTran, LEVEL_EXECUTIVE), "Executive", "exe-pic"));
        
        return levels;
    }
}
