package performa.search;

import oneit.objstore.BaseBusinessClass;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.rdbms.filters.ILikeFilter;
import oneit.servlets.jsp.ORMTextSearcher;
import performa.orm.Company;


public class CompanySearcher implements ORMTextSearcher
{
    public static CompanySearcher INSTANCE = new CompanySearcher();

    @Override
    public BaseBusinessClass[] search(ObjectTransaction ot, String searchTerm)
    {
        return Company.SearchByAll().andCompanyName(new ILikeFilter(searchTerm, "%", "%")).search(ot);
    }
}