
-- DROP TABLE tl_job;




CREATE TABLE tl_job (
    object_id number(12) NOT NULL ,
    object_last_updated_date date DEFAULT SYSDATE NOT NULL ,
    object_created_date date DEFAULT SYSDATE NOT NULL
    ,
    job_title varchar2(30) NOT NULL,
    job_description clob NOT NULL,
    job_status varchar2(200) NOT NULL,
    open_date date NULL,
    apply_by date NULL,
    include_assessment_criteria char(1) NOT NULL,
    assessment_type varchar2(200) NOT NULL,
    random_key varchar2(10) NULL,
    job_type varchar2(200) NOT NULL,
    ref_number varchar2(10) NULL,
    last_status_change_date date NULL,
    remote char(1) NULL,
    city varchar2(100) NULL,
    postcode varchar2(100) NULL,
    location_radius varchar2(200) NOT NULL,
    state varchar2(200) NULL,
    country varchar2(200) NULL,
    require_cv char(1) NULL,
    manually_closed char(1) NULL,
    last_edited date NULL,
    is_ppj char(1) NULL,
    industry varchar2(200) NOT NULL,
    culture_statement varchar2(2000) NULL,
    draft_location varchar2(200) NULL,
    google_address_text varchar2(300) NOT NULL,
    level_id number(12)  NULL,
    client_id number(12)  NULL,
    job_owner_id number(12)  NULL,
    company_user_id number(12)  NULL,
    hiring_team_id number(12)  NULL,
    occupation_id number(12)  NOT NULL,
    shortened_url_id number(12)  NULL,
    template_id number(12)  NULL,
    job_title_id number(12)  NOT NULL
    );



ALTER TABLE tl_job ADD    
    CONSTRAINT PK_tl_job PRIMARY KEY 
    (
        object_id
    ) ;
    
    
    
    CREATE INDEX idx_tl_job_client_id 
    ON tl_job (client_id);
