import { CLASSES } from '../constants';
import { ApplicantSourcesEnum } from './applicant-sources.enum';
import { ApplicationStatusEnum } from './application-status.enum';
import { CandidateModel } from "./candidate.model";
import { JobModel } from "./job.model";
import { MessageModel } from './message.model';
import { WorkflowStageModel } from './workflow-stage.model';

export class JobApplicationModel {
    ObjectID: string;
    ObjectClass = CLASSES.JOB_APPLICATION;
    id: string;
    CV: string;
    CoverLetter: string;
    ApplicationStatus: ApplicationStatusEnum;
    SubmittedDate: string;
    GoogleAddressText: string;
    PreferRemote: boolean;
    HappyToRelocate: boolean;
    IsEmailIngest: boolean;
    ApplicantSource: ApplicantSourcesEnum;
    AppProcessOption: string;
    OverallRank: number;
    RoleFit: string;
    RequirementFit: string;
    CultureFit: string;
    FactorScoreDetails: string;
    Note: string;
    Candidate: CandidateModel;
    Job: JobModel;
    WorkFlowStage: WorkflowStageModel;
    AssessmentCriteriaAnswers: Array<string>;
    Notes: Array<string>;
    ScheduledEmails: Array<string>;
    SentEmails: Array<string>;
    Messages: Array<string>;
}
