import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { takeUntil } from 'rxjs/operators';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { CareerProfileModel } from '../../models/career-profile.model';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { HelperService } from '../../services/helper.service';
import { ToasterService } from '../../services/toaster.service';

@Component({
    selector: 'app-home',
    templateUrl: './home.component.html',
    styleUrls: ['./home.component.scss']
})
export class HomeComponent extends BaseComponent implements OnInit {

    selectedMobileTab = 'dashboard';
    careerProfile = new CareerProfileModel();
    assocs = ['Candidate.User', 'Candidate.OccupationPreference'];

    constructor(
        private ps: PersonalDetailsService,
        private hs: HelperService,
        private us: UtilsService,
        private ts: ToasterService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.us.cloneObject(profile);
            });
        this.ts.warning('You have completed your Career History, one step closer to done.')
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
                this.ps.careerProfileUpdated = this.careerProfile;
                this.isLoading = false;
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

}
