package performa.orm;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.InFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.CollectionUtils;
import oneit.utils.ObjectTransform;
import oneit.utils.filter.Filter;
import performa.orm.types.CultureClass;


public class CultureCriteriaTemplate extends BaseCultureCriteriaTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public CultureCriteriaTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    
    @Override
    public String getToString() 
    {
        return getTemplateName();
    }
    
    
    public Collection<CultureCriteria> getCultureCriteriasForClass(CultureClass cultureClass)
    {
        Filter  elementFilter   =   CultureElement.SearchByAll().andCultureClass(new EqualsFilter(cultureClass));
        
        Set<CultureElement> cultureElements =   pipelineCultureCriteriaTemplate().toCultureCriterias().toCultureElement(elementFilter).uniqueVals();
        
        Filter  criteriaFilter  =   CultureCriteria.SearchByAll().andCultureElement(new InFilter(cultureElements));
        
        return ObjstoreUtils.sort(pipelineCultureCriteriaTemplate().toCultureCriterias(criteriaFilter).vals(), 
                                    new ObjectTransform[]{CultureCriteria.pipesCultureCriteria().toObjectID()},
                                    new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
    }
}