/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BitcoinReceiverCollection;
import com.stripe.model.BitcoinTransactionCollection;
import com.stripe.model.DeletedBitcoinReceiver;
import com.stripe.model.ExternalAccount;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class BitcoinReceiver
extends ExternalAccount {
    Boolean active;
    Long amount;
    Long amountReceived;
    Long bitcoinAmount;
    Long bitcoinAmountReceived;
    String bitcoinUri;
    Long created;
    String currency;
    String description;
    String email;
    Boolean filled;
    String inboundAddress;
    Boolean livemode;
    String payment;
    String refundAddress;
    Boolean rejectTransactions;
    String status;
    BitcoinTransactionCollection transactions;
    Boolean uncapturedFunds;
    Boolean usedForPayment;

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getAmountReceived() {
        return this.amountReceived;
    }

    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    public Long getBitcoinAmount() {
        return this.bitcoinAmount;
    }

    public void setBitcoinAmount(Long bitcoinAmount) {
        this.bitcoinAmount = bitcoinAmount;
    }

    public Long getBitcoinAmountReceived() {
        return this.bitcoinAmountReceived;
    }

    public void setBitcoinAmountReceived(Long bitcoinAmountReceived) {
        this.bitcoinAmountReceived = bitcoinAmountReceived;
    }

    public String getBitcoinUri() {
        return this.bitcoinUri;
    }

    public void setBitcoinUri(String bitcoinUri) {
        this.bitcoinUri = bitcoinUri;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getFilled() {
        return this.filled;
    }

    public void setFilled(Boolean filled) {
        this.filled = filled;
    }

    public String getInboundAddress() {
        return this.inboundAddress;
    }

    public void setInboundAddress(String inboundAddress) {
        this.inboundAddress = inboundAddress;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getPayment() {
        return this.payment;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }

    public String getRefundAddress() {
        return this.refundAddress;
    }

    public void setRefundAddress(String refundAddress) {
        this.refundAddress = refundAddress;
    }

    public Boolean getRejectTransactions() {
        return this.rejectTransactions;
    }

    public void setRejectTransactions(Boolean rejectTransactions) {
        this.rejectTransactions = rejectTransactions;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BitcoinTransactionCollection getTransactions() {
        return this.transactions;
    }

    public void setTransactions(BitcoinTransactionCollection transactions) {
        this.transactions = transactions;
    }

    public Boolean getUncapturedFunds() {
        return this.uncapturedFunds;
    }

    public void setUncapturedFunds(Boolean uncapturedFunds) {
        this.uncapturedFunds = uncapturedFunds;
    }

    public Boolean getUsedForPayment() {
        return this.usedForPayment;
    }

    public void setUsedForPayment(Boolean usedForPayment) {
        this.usedForPayment = usedForPayment;
    }

    public static BitcoinReceiver create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.create(params, null);
    }

    public static BitcoinReceiver retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.retrieve(id, null);
    }

    public static BitcoinReceiver create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers"), params, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiver retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.GET, String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", id), null, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiverCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, null);
    }

    public static BitcoinReceiverCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers");
        return BitcoinReceiver.requestCollection(url, params, BitcoinReceiverCollection.class, options);
    }

    @Deprecated
    public static BitcoinReceiverCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, null);
    }

    @Deprecated
    public static BitcoinReceiverCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, options);
    }

    @Override
    public String getInstanceURL() {
        String result = super.getInstanceURL();
        if (result == null) {
            return String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", this.getId());
        }
        return result;
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, BitcoinReceiver.class, options);
    }

    @Override
    public DeletedBitcoinReceiver delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    @Override
    public DeletedBitcoinReceiver delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedBitcoinReceiver.class, options);
    }
}

