<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");

    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS_GRID);

%>


    <script type="text/javascript">
        $(document).ready(function()
        {
            $('.grid-box-view').slick({
                dots: false,
                infinite: false,
                speed: 300,
                slidesToShow: 5,    
                nextArrow: "<div class='sl_width slider-next'><span><img src='images/slider-arrow.png' /></span></div>",
                prevArrow: "<div class='sl_width slider-prev'><span><img src='images/slider-arrow-left.png' /></span></div>",
                responsive: [
                {
                  breakpoint: 1280,
                  settings: {
                    slidesToShow: 4
                  }
                },
                {
                  breakpoint: 1024,
                  settings: {
                    slidesToShow: 3
                  }
                },
                {
                  breakpoint: 600,
                  settings: {
                    slidesToShow: 2
                  }
                },
                {
                  breakpoint: 480,
                  settings: {
                    slidesToShow: 1
                  }
                }
              ]
            });
            
            recalcFunction = setupRecalc ($("form#viewApplicants"), {'recalcOnError':true});
        });
    </script>
 

    <div class="five-boxs">
        <%
            int index   = 0;

            for(JobApplication jobApplication : applications)
            {
                String  appID       =   "app-id-" + jobApplication.getID().toString();
                Integer overallRank =   jobApplication.getOverallRank();
                Boolean isTopRank   =   CollectionUtils.equals(overallRank, 1);
                boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
        %>
                <div class="appl-c-box application-row">
                    <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                    <div class="cb-title dark-back">
                        <div class="checkbox-list grid-checkbox">
                            <div class="checkbox-list">
                                <input type="checkbox"  name="IsSelected" value="<%= jobApplication.getObjectID().toString() %>"  id="<%= appID %>" class="applicant" >
                                <label for="<%= appID %>">
                                    <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                                </label>
                            </div>
                        </div>  
                    </div>
                    <oneit:button   value=" "    name="gotoPage" cssClass="<%= jobApplication.getID() + ""%>" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", applications).toMap())
                                                                    .toMap() %>">
                        <div class="overall-suitablity">
                            <div class="<%= "overall " + (isTopRank ? "f-60" : "")%>">overall rank</div>
                            <div class="<%= "over-all blue " + (isTopRank ? "f-60" : "")%> ">
                                <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                            </div>
                        </div>
                        <div class="jcc-box">
                            <div class="job-match jcc">
                                <img src="images/app-job-match-icon.svg"> role fit 
                                <span>
                                    <oneit:button   value=" "   name="gotoPage" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>">
                                        <oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"    mode="PercentageWholeNumber" />
                                    </oneit:button>
                                </span>
                            </div>
                            <div class="culture jcc">
                                <img src="images/culture-icon.svg"> culture fit
                                <span>
                                    <oneit:button   value=" "   name="gotoPage" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>">
                                        <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                                    </oneit:button>
                                </span>
                            </div>
                            <%
                                if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                                {
                            %>
                                    <div class="criteria jcc">
                                        <!--TODO: Use missingReq attribute, if true make background red and add image. If 100% make background green-->
                                        <img src="images/criteria-icon.svg"> requirements
                                        <span>
                                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                            .toMap() %>">
                                                <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"  mode="PercentageWholeNumber" />
                                            </oneit:button>
                                        </span>
                                    </div>
                            <%
                                }
                            %>
                        </div>
                    </oneit:button>
                </div>
        <%
                index++;
            }
        %>
    </div>
</oneit:dynIncluded>