import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from '../../../environments/environment';
import { ApiService } from '../../oneit/services/api.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class AuthService {

    env = environment.envName;

    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {
    }

    login(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/Login', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

    forgot(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/RequestPasswordReset', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

    register(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/RegisterMyCareerUser', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

    reset(formData): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/PasswordChange', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

    logout(formData = {} as any): Observable<any> {
        formData.environment = this.env;

        return this.apiService.post('svc/Logout', formData)
            .map(
                data => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        return data;
                    }
                }
            );
    }

}
