package performa.form;

import java.util.Map;
import oneit.objstore.ObjectTransaction;
import oneit.security.LoginProcessor;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.utils.MultiException;
import oneit.utils.parsers.FieldException;
import performa.orm.CompanyUser;
import performa.utils.Utils;

/**
 *
 * @author nilu
 */
public class UserLoginFP extends LoginProcessor
{
    @Override
    protected void checkUserCanLogin(ObjectTransaction trans, SecUser userToCheck, SubmissionDetails submission, Map requestParams) throws FieldException, MultiException
    {
        super.checkUserCanLogin(trans, userToCheck, submission, requestParams);
                
        CompanyUser companyUser =   userToCheck.getExtension(CompanyUser.REFERENCE_CompanyUser);
        
        if(!Utils.checkAdminPortalAccess(userToCheck) || companyUser == null || companyUser.getIsAccountVerified()!=Boolean.TRUE)
        {
            throw new FieldException("You're not an authorised user to access this portal.", SecUser.FIELD_UserName);
        }
    }
}