import { Component, OnDestroy, OnInit } from '@angular/core';
import { HelperService } from '../../services/helper.service';
import { BaseComponent } from '../../base/base.component';

@Component({
    selector: 'app-account',
    templateUrl: './account.component.html',
    styleUrls: ['./account.component.scss']
})
export class AccountComponent extends BaseComponent implements OnInit, OnDestroy {

    showCardPopup = false;

    constructor(
        private helperService: HelperService
    ) {
        super();
    }

    ngOnInit(): void {
        this.helperService.hideTaskBar = true;
    }

    ngOnDestroy(): void {
        super.ngOnDestroy();
        this.helperService.hideTaskBar = false;
    }

}
