import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { environment } from '../../../../environments/environment';
import { ApiService } from '../../../oneit/services/api.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class ApplicantPortalLayoutService {

    userDataUpdated = new Subject<any>();
    userData: any;
    jobApplicationID: string;

    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {

    }

    reloadApplicantUserDetails(jobApplicationID): void {
        if (jobApplicationID) {
            const params = {
                environment: environment.envName,
                JobApplication: jobApplicationID
            };

            this.apiService.post('svc/ApplicantUserDetails', params)
                .subscribe(
                    data => {
                        if (this.utilsService.isSuccessfulResponse(data)) {
                            this.jobApplicationID = jobApplicationID;
                            this.userData = data;
                            this.userDataUpdated.next(data);
                        }
                    });
        }
    }
}
