import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { MessageEngineHiringTeamViewService } from './message-engine-hiring-team-view.service';

import { EngineHiringTeamView } from './message-engine-hiring-team-view.model';

@Component({
    selector: 'app-message-engine-hiring-team-view',
    templateUrl: './message-engine-hiring-team-view.component.html'
})
export class MessageEngineHiringTeamViewComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    engineHiringTeamView = new EngineHiringTeamView();
    ButtonItems: MenuItem[];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private messageEngineHiringTeamViewService: MessageEngineHiringTeamViewService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getEngineHiringTeamViewByID(params.id);
                    } else {
                        this.utilsService.createObject(this.engineHiringTeamView, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
            this.ButtonItems = [

            {
                label: 'via On app', 
                command: () => {
                    
                }
            },
            {
                label: 'Email', 
                command: () => {
                    
                }
            },
            {
                label: 'SMS', 
                command: () => {
                    
                }
            }
            ];
    }
    

    getEngineHiringTeamViewByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.messageEngineHiringTeamViewService.getEngineHiringTeamViewByID(id, assocs)
            .subscribe(
                data => {
                    this.engineHiringTeamView = data;
                    this.updatedObjs[this.engineHiringTeamView.ObjectID] = this.engineHiringTeamView;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveEngineHiringTeamView(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.engineHiringTeamView.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/message-engine-hiring-team-view", idToNavigate]);
                                return;
                            }
                            this.getEngineHiringTeamViewByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}