package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import performa.orm.CultureCriteriaAnswer;
import performa.orm.JobApplication;


public class SaveAndExitCultureFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request         =   submission.getRequest();
        JobApplication      jobApplication  =   process.getAttribute("JobApplication") != null ? (JobApplication) process.getAttribute("JobApplication") : (JobApplication) request.getAttribute("JobApplication");
        
        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In SaveAndExitCultureFP saving job application: ", jobApplication );

        for (CultureCriteriaAnswer answer : jobApplication.getCandidate().getCultureCriteriaAnswersSet())
        {
            if(answer.getSelectedQuestion() == null)
            {
                LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING1,"In SaveAndExitCultureFP deleting CultureCriteriaAnswer : ", answer );

                answer.delete();
            }
        }
        return super.processForm(process, submission, params);
    }
}