import { Component, OnInit } from '@angular/core';
import { Subscription } from 'rxjs';
import { UtilsService } from '../../oneit/services/utils.service';
import { SearchApplicantService } from './search-applicants.service';

@Component({
  selector: 'app-search-applicants',
  templateUrl: './search-applicants.component.html',
  styleUrls: ['./search-applicants.component.css']
})
export class SearchApplicantsComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    
    applicants  : any[] = [];
    showLoader  : boolean   = false;
    showResult  : boolean   = false;
    details     : string
    
    constructor(
        private utilsService: UtilsService,
        private searchApplicantService : SearchApplicantService){
        
    }

    cols = [
        { field: 'User.Name',          header: 'Name',           width: '30%',   noSort: false,    noFilter: false},
        { field: 'User.Email',         header: 'Email',          width: '30%',   noSort: false,    noFilter: false},
        { field: 'NoOfJobs',           header: 'No of Jobs',     width: '30%',   noSort: false,    noFilter: false},
        { field: '',                    header: '',               width: '10%',   noSort: true,     noFilter: true}
    ];

    ngOnInit() {
    }
    
    getApplicants() {
        var ob = {
            Details : this.details
        }
        this.showLoader = true;
        this.subscriptions.push(this.searchApplicantService.getApplicants(ob, ['User']).subscribe(data => {
            this.applicants = data;
            this.showLoader = false;
            this.showResult = true;
        },
        error => {
            this.utilsService.handleError(error);
            this.showLoader = false;
        }))
    }

    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }

}
