<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="en">
    <head>
        <meta charset="utf-8"></meta>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
        <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
        <%
            Company     company         =   clientUser != null && clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser) != null
                                                ? clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser).getCompany() : null;
            CompanyUser companyUser     =   clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
            String      gtmKey          =   oneit.appservices.config.ConfigMgr.getKeyfileString("gtm.key","GTM-M6M4SW6");
            HiringTeam  selectedTeam    =   Utils.getSelectedTeam(request, companyUser, objTran);
        %>
        
        <title><%= "Matchd" + (company != null ? " - " + company.getCompanyName() : "")%></title>
        <%@include file="/inc/std_imports.jsp" %>
        <%@include file="/hotjar.jsp" %>
        <%@page import="oneit.servlets.portability.BrowserServices"%>
        
        <!--filter on applicant list-->
        <script src="https://cdn.jsdelivr.net/npm/vue@^2"></script>
        <script src="https://cdn.jsdelivr.net/npm/@riophae/vue-treeselect@0.0.38/dist/vue-treeselect.min.js"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@riophae/vue-treeselect@0.0.38/dist/vue-treeselect.min.css">
            
        <%
            if(Utils.SHOW_ADMIN_PORTAL_IN_IFRAME)
            {
                String redirectURL  =   Utils.getURLForParent(request);
        %>
                <script>
                    function inIframe () {
                        try {
                            return window.self !== window.top;
                        } catch (e) {
                            return true;
                        }
                    }
                    if(!inIframe()) {
                        window.location.href = '<%= redirectURL %>';
                    }
                </script>
                <style>
                    .dashboard-content-area, .main-content-area {
                        width: 100% !important;
                    }
                </style>
        <%
            }
        %>
        <!-- Google Tag Manager -->
        <script>
            dataLayer = [{
                'userId': '<%= clientUser != null ? clientUser.getUserName() : "" %>',
                'stripeId': '<%= selectedTeam != null ? selectedTeam.getStripeReference() : "" %>',
            }];
        </script>
        <script>
            (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start': new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0], j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);})(window,document,'script','dataLayer','<%= gtmKey %>');
        </script>
        <!-- End Google Tag Manager -->
    </head>
    <script>
        
        $(document).ready(function(){
            $(".oneit-radio input").each(function(){

                if($(this).is(':checked')) { 
                   updateRadioChecked(this); 
                }

                $(this).click(function(){
                    if($(this).is(':checked')) { 
                        updateRadioChecked(this); 
                    }
                });
            });
        });
         
        function updateRadioChecked(ele){
            $("input[name='"+ $(ele).attr('name') +"'").closest('label').removeClass('checked');
            $("input[name='"+ $(ele).attr('name') +"'").closest('.oneit-radio').removeClass('checked');
           
            $(ele).closest('label').addClass('checked');
            $(ele).closest('.oneit-radio').addClass('checked');
        }
    </script>
    
    <body>
    <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<%= gtmKey %>" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    <%
        boolean isMobile        =   BrowserServices.isMobile(request);

        if(isMobile)
        {
            String accept           = request.getHeader("accept");
            String userAgent        = request.getHeader("user-agent");
            String uaOS             = request.getHeader("UA-OS");
            
            LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "IsMobile accept :", accept, " user agent: ", userAgent, " uaOS: ", uaOS );
            
            response.sendRedirect(request.getContextPath() + "/extensions/adminportal/responsive_alert.jsp");
        }
    
        Article home            =   WebUtils.getArticleByShortCut(objTran, WebUtils.ADMIN_HOME);
        Article companyArticle  =   WebUtils.getArticleByShortCut(objTran, WebUtils.MY_COMPANY);
        String  homeUrl         =   home.getLink(request);
        String  signoutUrl      =   "logout.jsp?nextURL=" + homeUrl;
        
        if(clientUser != null)
        {
            if(!Utils.SHOW_ADMIN_PORTAL_IN_IFRAME)
            {
    %>
            <header>
                <oneit:form name="headerForm" method="post"    enctype="multipart/form-data">
                    <script type="text/javascript">
                        $(document).ready(function() 
                        {
                             $('select[name$=SelectedTeam]').change(function()
                            {
                                $('.change-hiring-team').click();
                            });

                            var toolpop =  new jBox('Tooltip', {
                                attach: '.info-icon',
                                pointer: 'right:5'
                            });
                            var toolpop =  new jBox('Tooltip', {
                               attach: '.info-icon-left',
                               pointer: 'left:5'
                            });
                        });
                        
                        function showReachedCap(){
                            $('#reachedCap').modal('show');
                        }
                        
                        function trialNotAllowed(){
                            $('#trialNotAllowed').modal('show');
                        }
                    </script>

                <div class="container-fluid">
                    <div class="row" style="background-color: #ffffff;">
                        <div class="site-logo">
                            <a href="<%= homeUrl %>"><img src="images/headerlogo.jpg"></a>
                        </div>
                        <div class="search-bar">
                            <%
                                if(companyUser != null)
                                {
                            %>
                                <div class="header-select">
                                    <tagfile:ormsingleasso_select obj="<%= companyUser %>"  assocName="SelectedTeam"    options="<%= Utils.getHiringTeamsByUser(companyUser) %>"
                                                                  cssClass="selected-team"/>
                                </div>
                            <%
                                }
                            %>
                            
                            <oneit:button   name="selectHiringTeam"  value="Save"    cssClass="change-hiring-team hidden"
                                                requestAttribs="<%= CollectionUtils.mapEntry("CompanyUser", companyUser)
                                                                                    .mapEntry("nextPage", homeUrl)
                                                                                    .toMap() %>" />
                            <%-- 
                            <div class="inset-shadow"></div>
                            <img src="images/search-icon.svg"/>
                            <input type="text" class="form-control" placeholder="<%= company.showHasClientSupport() ? "Search for job, candidate or client" : "Search for a job or candidate"%>"/>
                            --%>
                        </div>
                        <div class="fl-right">
                            <div class="notification-bar">
                                <div class="tack-center">
                                    <a href="#" data-toggle="dropdown">
                                        <!--TODO: enable when there are notifications-->
                                        <!--<span class="notification-label"></span>-->
                                        <img src="images/notification-icon.svg">
                                    </a>
                                    <ul class="profile-dropdown dropdown-menu">
                                        <span class="arrow-up"></span>
                                        <li><a href="#">No new notifications</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="user-profile-dropdown">
                                <a href="#" class="user-name" data-toggle="dropdown">
                                    <oneit:toString value="<%= Utils.getClientUserName(clientUser) %>" mode="EscapeHTML"/>
                                    <img src="images/arrow.svg"/>
                                </a>
                                <ul class="profile-dropdown dropdown-menu">
                                    <span class="arrow-up"></span>
                                    <%
                                        Article myDetailsArticle =   WebUtils.getArticleByShortCut(objTran, WebUtils.MY_DETAILS);
                                    %>
                                        <li><a href="<%= myDetailsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "Page").toMap())%>">My Details</a></li>
                                        <li><a href="<%= signoutUrl %>">Sign Out</a></li>
                                    <% 
                                        if (request.getSession ().getAttribute (oneit.security.jsp.AssumeUserFP.UNASSUME_SEC_USER_ID) != null)
                                        { 
                                    %>
                                            <li><a href="<%= request.getContextPath () %>/editor/index_unassume.jsp">Unassume</a></li>
                                    <%    
                                        }
                                    %>
                                </ul>
                            </div>
                            <div class="create-job-btn">
                                <%
                                    if(selectedTeam != null && companyUser != null)
                                    {
                                        Article jobsArticle         =   WebUtils.getArticleByShortCut(objTran, WebUtils.JOBS);
                                        boolean onJob           =   WebUtils.onJobPages(renderMode);
                                        boolean hasBillingSetup =   selectedTeam.hasBillingSetup();
                                        boolean canCreateJob    =   selectedTeam.allowJobCreation();
                                        boolean trialNotAllowed =   selectedTeam.trialJobNotAllowed();
                                %>
                                        <a href="<%= onJob || !canCreateJob ?  "javascript:void(0);": jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.START_JOB).toMap()) %>" class="<%= onJob || !hasBillingSetup ? "disabled" : ""%>" onclick="<%= canCreateJob ? "" : trialNotAllowed ? "trialNotAllowed()" : "showReachedCap()"%>">Create Job</a>
                                <%
                                    }
                                %>
                            </div>
                        </div>
                    </div>
                </div>
                </oneit:form>
            </header>
            <%
                if(selectedTeam != null && companyUser != null)
                {
            %>
                    <div class="modal fade" id="reachedCap" role="dialog">
                        <div class="modal-dialog welcome-pop-top">
                            <div class="modal-body main-welcome-popup">
                                <h2>Your account reached monthly cap!</h2>
                                <%
                                    if(companyUser.getRoleForHiringTeam(selectedTeam) == RoleType.STANDARD)
                                    {
                                %>                            
                                        <p>Your account has reached the monthly cap for number of jobs, contact your Administrator to have the Cap increased.</p>
                                <%
                                    }
                                    else
                                    {
                                %>                            
                                        <p>Your account has reached the monthly cap for number of jobs. Please make a request by contacting us to make changes.</p>
                                        <div class="create-y-f-job">
                                            <a href=" https://www.matchd.com/support/" target="_blank">Make a Request</a>
                                        </div>
                                <%
                                    }
                                %>
                            </div>          
                        </div>
                    </div>
                    <oneit:form name="popupForm" method="post"    enctype="multipart/form-data">
                        <div class="modal fade" id="trialNotAllowed" role="dialog">
                            <div class="modal-dialog welcome-pop-top">
                                <div class="modal-body main-welcome-popup">
                                    <h2>Your account is on trial!</h2>
                                    <%
                                        if(companyUser.getRoleForHiringTeam(selectedTeam) == RoleType.STANDARD)
                                        {
                                    %>                            
                                            <p>Only one Job can be created during the Trial. Please contact your Administrator to set up billing</p>
                                    <%
                                        }
                                        else
                                        {
                                    %>                            
                                            <p>Only one Job can be created during the Trial. <%= selectedTeam.getCardID() == null ? "Enter Billing Method and" : "" %> Select Plan to enable creation of additional jobs.</p>
                                            <div class="create-y-f-job">
                                                <oneit:button   value=" "    name="gotoPage"    skin="link"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", companyArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", selectedTeam.getCardID() == null ? "Billing" : "ManagePlan").toMap()))
                                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("HiringTeam", selectedTeam).toMap())
                                                                                                    .toMap() %>">
                                                    Setup <%= selectedTeam.getCardID() == null ? "Billing" : "Payment Plan" %>
                                                </oneit:button>
                                            </div>
                                    <%
                                        }
                                    %>
                                </div>          
                            </div>
                        </div>
                    </oneit:form>
        <%
                }
            }
        %>                
            <script type="text/javascript">
                $(document).ready(function()
                {
                    if($('.dashboard-content-area').height() < $(window.parent.document).height())
                    {
                        ($('.dashboard-content-area').hasClass('second-part') ) ? 
                        $('.dashboard-content-area').height($(window.parent.document).height() - $('.dashboard-content-area').outerHeight() + $('.dashboard-content-area').height() - 65) : 
                        $('.second-part').innerHeight( $(window.parent.document).height() - $('.dashboard-first-part').outerHeight() - 65 )
                    }
                });
            </script> 
    <%
        }
    %>
