import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { ListApplicantsService } from './list-applicants.service';


@Component({
    selector: 'app-list-applicants',
    templateUrl: './list-applicants.component.html'
})
export class ListApplicantsComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    types: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private listApplicantsService: ListApplicantsService
    ){
        
    }

    ngOnInit() {

        this.getTypes();
    }
    

    getTypes() {
        this.subscriptions.push(this.listApplicantsService.gettypes([])
            .subscribe(
                data => {
                    this.types = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}