<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "reset_password_jsp"; } %>

<%
    ORMProcessState     process             =   (ORMProcessState)ProcessDecorator.getDefaultProcess(request);
    String              companyUserID       =   (String) process.getAttribute("companyUserID"); //request.getParameter("id");
    String              forgotpasswordCode  =   (String) process.getAttribute("forgotpasswordCode"); //request.getParameter("key");
    SecUser             user                =   (SecUser) process.getAttribute("SecUser");
    Article             home                =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME);
    String              nextPage            = 	home.getLink(request);
    
    if(request.getParameter("id")!=null)
    {
        companyUserID       =   request.getParameter("id");
        process.setAttribute("companyUserID", companyUserID);
    }
    
    if(request.getParameter("key")!=null)
    {
        forgotpasswordCode  =   request.getParameter("key");
        process.setAttribute("forgotpasswordCode", forgotpasswordCode);
    }
    
    if(StringUtils.subBlanks(companyUserID) != null)
    {
        CompanyUser   companyUser   =   CompanyUser.getCompanyUserForForgotPassword(process.getTransaction(), companyUserID, forgotpasswordCode);

        if(companyUser != null)
        {
            user    =  companyUser.getUser();

//            if(StringUtils.subBlanks(forgotpasswordCode) != null)
//            {
//                RandomStringGen     random  =   new RandomStringGen();
//
//                user.setAttribute("md5:Password", random.generateAlphaNum(8));
//            }

            process.setAttribute("SecUser", user);
        }
    }
%>

<html lang="en">
    <head>
        <meta charset="utf-8"></meta>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
        <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
        <title>Talentology</title>
                
        <%@include file="/inc/std_imports.jsp" %>
    </head>
    
    <body class="bg-color">
        <script type="text/javascript">
            $(document).ready(function() {
                validate();
                $('input').on('change keyup', function() { validate() });
            });
            
            function validate() {
                var empty = false;
                $('.password-field').each(function() {
                    if ( $.trim($( this ).val()) == '') {
                        empty = true;
                    }
                });

                if (empty) {
                    $('.reset-btn').attr('disabled', 'disabled');
                } else {
                    $('.reset-btn').removeAttr('disabled');
                }
            }
        </script>
        <style>
            button[disabled] {
                opacity: 0.6;
                background-color: #0582ba;
            }
        </style>
        <div class="container">
            <div class="row">    
                <div class="main-verify-identity">
                    <div class="login-logo"><img src="<%= request.getContextPath() %>/images/logo.svg" /></div>
                    <oneit:form name="resetPassword"    method="post">
                        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <%
                            if(user!=null)
                            {
                                String  key =   Utils.getPwdKeyOfSecUser(request, user, true);
                        %>
                                <div class="main-box-layout login-box">
                                    <div class="text-left">
                                        <p >
                                            Please enter a new password below.
                                        </p>
                                    </div>
                                    <div>&nbsp;</div>
                                    <div class="form-group text-left">
                                        <label>Password *</label>
                                        <oneit:input type="password" name="<%= key %>"      class="form-control password-field"/>
                                    </div> <!-- form-group -->
                                    <div class="form-group text-left">
                                        <label>Confirm Password *</label>
                                        <oneit:input type="password" name="<%= key + 2 %>"  class="form-control password-field"/>
                                    </div> <!-- form-group -->
                                    <div class="col-sm-12">
                                        <oneit:button   value="Set New Password"    name="resetPassword"  cssClass="box-btn reset-btn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage).toMap() %>"/>
                                    </div>
                                </div>
                        <%
                            }
                            else
                            {
                        %>
                                <h3 class="text-danger">Invalid User or this link has been expired, generate new link to access this page.</h3>
                        <%
                            }
                        %>
                    </oneit:form>
                </div>
            </div>
        </div>
    </body>
</html>
