<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran     =   process.getTransaction ();
    Job[]               jobs        =   Job.SearchByAll().search(transaction);
    String              nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String              homePage    =   WebUtils.getSamePageInRenderMode(request, "Page");
%>

    <script type="text/javascript">
       
        $(document).ready(function() 
        {
            $(".job-row").click(function() 
            {
                var id  = $(this).closest('.job-list').attr('id');
                $('.' + id).click();
            });
            
            $(".job-status").change(function(){
                var id  = $(this).closest('.job-list').attr('id');
                $('.save-job' + id).click();
            });
            
        });
    </script>
    
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="dashboard-content-area second-part">
            <div class="jobs-list-shorting">
            <div class="d-job-title all-jobs-title">All Jobs</div>
                <div class="job-filter">
                    <ul class="">
                        <li class="lable-job-shorting">showing</li>
                        <li class="active"><a href="#">ALL JOBS</a></li>
                        <li><a href="#">OPEN</a></li>
                        <li><a href="#">COMPLETE</a></li>
                        <li><a href="#">DRAFT</a></li>
                    </ul>
                </div>
                <div class="shorting-dropdown">
                    <span class="order-label">order by</span>
                    <select class="form-control">
                        <option>Alphabetical (A-Z)</option>
                        <option>Alphabetical (Z-A)</option>
                    </select>
                </div>
            </div>
            <div class="main-job-list">
            <%
                for(Job job: jobs)
                {
            %>
                    <div class="job-list"   id="<%= job.getID() %>">
                        <div class="job-row"   >
                            <div class="job-post jl-c eq-second-height" style="height: 107px;">
                                <div class="job-post-name">
                                    <oneit:toString value="<%= job.getJobTitle() %>" mode="EscapeHTML" />
                                    <oneit:button   value="EDIT"   name="gotoPage" cssClass="<%= job.getID() + " hidden"%>"   skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                                .toMap() %>"/>
                                </div>
                                <div class="job-company-name">
                                    <span class="superlaw">SUPERLAW</span>
                                    <span class="calendar"><oneit:toString value="<%= job.getDaysTillClose() %>"    mode="EscapeHTML"/></span>
                                </div>
                            </div>
                            <div class="job-application jl-c eq-second-height" style="height: 107px;">
                                <div class="ja-icon"><img src="images/job-list-user.png"></div>
                                <div class="ja-count">
                                    <oneit:toString value="<%= job.getNoOfCandidatesApplied() %>"   mode="EscapeHTML"   nullValue="0"/>
                                    <span class="grey-span">Applicants</span>
                                </div>
                            </div>
                            <div class="job-shortlisted jl-c eq-second-height" style="height: 107px;">
                                <div class="ja-icon"><img src="images/circle.png"></div>
                                <div class="ja-count">
                                    <oneit:toString value="<%= job.getNoOfCandidatesShortlisted() %>"   mode="EscapeHTML"   nullValue="0"/>/5
                                    <span class="grey-span">shortlisted</span>
                                </div>
                            </div>
                        </div>
                        <div class="job-states jl-c">
                            <oneit:ormEnum  obj="<%= job %>" attributeName="JobStatus" cssClass="form-control status-img job-status"   
                                            enums="<%= Arrays.asList(new JobStatus[]{JobStatus.OPEN, JobStatus.COMPLETE}) %>"/>
                        </div>
                        <oneit:button   name="save" value="Save"    cssClass="<%= "save-job" +  job.getID().toString() + " hidden"%>"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage)
                                                                                                        .mapEntry("Job", job)
                                                                                                        .toMap() %>" />
                    </div>
            <%
                }
            %>
            
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
