import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class MyCareerUsersService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getCareerUsers(queryParams, assocs, saveSearch: boolean): Observable<any> {
        return this.searchService.searchAndSaveSearchRequest("CareerProfiles", "All", queryParams, assocs, null, null, null, null, "CareerProfiles", saveSearch)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            );
    }
    
}