import { Injectable } from '@angular/core';
import { UtilsService } from '../../oneit/services/utils.service';
import { SearchService } from '../../oneit/services/search.service';
import { Observable } from 'rxjs';
import { SERVICES } from '../config/constants';
import { SaveService } from '../../oneit/services/save.service';
import { IntroductionLetterModel } from '../models/introduction-letter.model';

@Injectable()
export class IntroLetterService {

    constructor(
        private us: UtilsService,
        private ss: SearchService,
        private svs: SaveService
    ) {
    }


    getIntroLetters(queryParams = {}, assocs = []): Observable<any> {
        return this.ss.getObjects(SERVICES.INTRODUCTION_LETTERS, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs);
                }
            )
    }

    getIntroLetter(id, assocs = []): Observable<IntroductionLetterModel> {
        return this.ss.getObjects(SERVICES.INTRODUCTION_LETTERS, 'ByID', {id: id}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs)[0];
                }
            )
    }

    saveIntroLetters(createdObjs, updatedObjs, deleteObjs): Observable<any> {
        return this.svs.saveObjectsWithDefaultSvc(createdObjs, updatedObjs, deleteObjs, true);
    }

}
