import { Component, EventEmitter, OnInit, Output, ViewChild } from '@angular/core';
import { BaseComponent } from '../../../base/base.component';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { NgForm } from '@angular/forms';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { ConfirmationService } from 'primeng/api';
import { HelperService } from '../../../services/helper.service';
import { takeUntil } from 'rxjs/operators';
import { CareerSkillModel, SkillModel } from '../../../models/career-skill.model';

@Component({
    selector: 'app-skills',
    templateUrl: './skills.component.html',
    styleUrls: ['./skills.component.scss']
})
export class SkillsComponent extends BaseComponent implements OnInit {

    assocs = ['Skills.Skill'];
    skills: SkillModel[] = [];
    careerProfile = new CareerProfileModel();
    ratings = [];

    @ViewChild('form') form: NgForm;
    @Output() skillsSaved = new EventEmitter();

    constructor(
        private ps: PersonalDetailsService,
        private us: UtilsService,
        private cs: ConfirmationService,
        private hs: HelperService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
        this.getSkillRatings();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
                this.us.addObjsToJSONByObjectID(this.updatedObjs, this.careerProfile.Skills);
                this.addSkill(true);
                this.isLoading = false;
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    getSkills($event): void {
        this.ps.getSkills({Description: $event.query})
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.skills = response;
            }, err => {
                this.hs.handleHttpError(err);
            })
    }

    getSkillRatings(): void {
        this.ps.getSkillRatings()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.ratings = response;
            }, err => {
                this.hs.handleHttpError(err);
            })
    }

    addSkill(initLoad = false): void {
        const newModel = new CareerSkillModel();
        newModel.CareerProfile = this.careerProfile.ObjectID;
        if (initLoad && (!this.careerProfile.Skills || this.careerProfile.Skills.length === 0)) {
            this.us.addMultiRefObject(newModel, this.careerProfile, 'Skills', this.createdObjs);
        } else if (!initLoad) {
            this.us.addMultiRefObject(newModel, this.careerProfile, 'Skills', this.createdObjs);
        }
    }

    removeSkill(exp): void {
        this.cs.confirm({
            message:'Are you sure you want to remove this skill?',
            accept: () => {
                this.us.removeMultiRefObject(exp, this.careerProfile, 'Skills', this.createdObjs, this.updatedObjs, this.deletedObjs);
            }
        })
    }

    saveSkill(): void {
        this.hs.validateAllFormFields(this.form);
        if (this.form.invalid) {
            return ;
        }
        this.isSaving = true;
        this.ps.saveProfile(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(res => {
                this.isSaving = false;
                this.hs.oneItHttpResponse(res);
                this.skillsSaved.emit();
            }, err => {
                this.hs.handleHttpError(err);
                this.isSaving = false;
            })
    }

}
