
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class FactorPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea FactorPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Factor");

    // Private attributes corresponding to business object data
    private Integer dummyFactorNo;
    private String dummyDescription;
    private String dummyClassCode;
    private String dummyNotes;
    private Integer dummyLevelNo;
    private String dummyLeftAnnot;
    private String dummyRightAnnot;
    private String dummyDescriptionSchinese;
    private String dummyDescriptionChinese;
    private String dummyDescriptionKorean;
    private String dummyDescriptionThai;
    private Double dummyZScoreWeight;
    private Double dummyZScoreWeight2;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_FactorNo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ClassCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Notes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LevelNo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LeftAnnot = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_RightAnnot = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DescriptionSchinese = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DescriptionChinese = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DescriptionKorean = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DescriptionThai = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ZScoreWeight = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ZScoreWeight2 = DefaultAttributeHelper.INSTANCE;
    



    public FactorPersistenceMgr ()
    {
        dummyFactorNo = (Integer)(HELPER_FactorNo.initialise (dummyFactorNo));
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        dummyClassCode = (String)(HELPER_ClassCode.initialise (dummyClassCode));
        dummyNotes = (String)(HELPER_Notes.initialise (dummyNotes));
        dummyLevelNo = (Integer)(HELPER_LevelNo.initialise (dummyLevelNo));
        dummyLeftAnnot = (String)(HELPER_LeftAnnot.initialise (dummyLeftAnnot));
        dummyRightAnnot = (String)(HELPER_RightAnnot.initialise (dummyRightAnnot));
        dummyDescriptionSchinese = (String)(HELPER_DescriptionSchinese.initialise (dummyDescriptionSchinese));
        dummyDescriptionChinese = (String)(HELPER_DescriptionChinese.initialise (dummyDescriptionChinese));
        dummyDescriptionKorean = (String)(HELPER_DescriptionKorean.initialise (dummyDescriptionKorean));
        dummyDescriptionThai = (String)(HELPER_DescriptionThai.initialise (dummyDescriptionThai));
        dummyZScoreWeight = (Double)(HELPER_ZScoreWeight.initialise (dummyZScoreWeight));
        dummyZScoreWeight2 = (Double)(HELPER_ZScoreWeight2.initialise (dummyZScoreWeight2));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}factor_hdr.object_id as id, {PREFIX}factor_hdr.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}factor_hdr.object_CREATED_DATE as CREATED_DATE, {PREFIX}factor_hdr.factor_number, {PREFIX}factor_hdr.factor_hdr_desc, {PREFIX}factor_hdr.class_code, {PREFIX}factor_hdr.factor_hdr_notes, {PREFIX}factor_hdr.level_number, {PREFIX}factor_hdr.left_annot, {PREFIX}factor_hdr.right_annot, {PREFIX}factor_hdr.factor_hdr_desc_schinese, {PREFIX}factor_hdr.factor_hdr_desc_chinese, {PREFIX}factor_hdr.factor_hdr_desc_korean, {PREFIX}factor_hdr.factor_hdr_desc_thai, {PREFIX}factor_hdr.z_score_wght, {PREFIX}factor_hdr.z_score_wght_2,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Factor.REFERENCE_Factor);

                if (objectToReturn instanceof Factor)
                {
                    LogMgr.log (FactorPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Factor");
                }
            }

            PersistentSet factor_hdrPSet = allPSets.getPersistentSet(id, "factor_hdr", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !factor_hdrPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_FactorNo)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_Description)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_ClassCode)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_Notes)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_LevelNo)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_LeftAnnot)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_RightAnnot)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_DescriptionSchinese)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_DescriptionChinese)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_DescriptionKorean)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_DescriptionThai)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_ZScoreWeight)||
                    !factor_hdrPSet.containsAttrib(Factor.FIELD_ZScoreWeight2))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (FactorPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Factor result = new Factor ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}factor_hdr " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}factor_hdr.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet factor_hdrPSet = allPSets.getPersistentSet(objectID, "factor_hdr");
            

            
            if (factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}factor_hdr " +
                                                           "SET factor_number = ?, factor_hdr_desc = ?, class_code = ?, factor_hdr_notes = ?, level_number = ?, left_annot = ?, right_annot = ?, factor_hdr_desc_schinese = ?, factor_hdr_desc_chinese = ?, factor_hdr_desc_korean = ?, factor_hdr_desc_thai = ?, z_score_wght = ?, z_score_wght_2 = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE factor_hdr.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_FactorNo.getForSQL(dummyFactorNo, factor_hdrPSet.getAttrib (Factor.FIELD_FactorNo))).listEntry (HELPER_Description.getForSQL(dummyDescription, factor_hdrPSet.getAttrib (Factor.FIELD_Description))).listEntry (HELPER_ClassCode.getForSQL(dummyClassCode, factor_hdrPSet.getAttrib (Factor.FIELD_ClassCode))).listEntry (HELPER_Notes.getForSQL(dummyNotes, factor_hdrPSet.getAttrib (Factor.FIELD_Notes))).listEntry (HELPER_LevelNo.getForSQL(dummyLevelNo, factor_hdrPSet.getAttrib (Factor.FIELD_LevelNo))).listEntry (HELPER_LeftAnnot.getForSQL(dummyLeftAnnot, factor_hdrPSet.getAttrib (Factor.FIELD_LeftAnnot))).listEntry (HELPER_RightAnnot.getForSQL(dummyRightAnnot, factor_hdrPSet.getAttrib (Factor.FIELD_RightAnnot))).listEntry (HELPER_DescriptionSchinese.getForSQL(dummyDescriptionSchinese, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionSchinese))).listEntry (HELPER_DescriptionChinese.getForSQL(dummyDescriptionChinese, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionChinese))).listEntry (HELPER_DescriptionKorean.getForSQL(dummyDescriptionKorean, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionKorean))).listEntry (HELPER_DescriptionThai.getForSQL(dummyDescriptionThai, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionThai))).listEntry (HELPER_ZScoreWeight.getForSQL(dummyZScoreWeight, factor_hdrPSet.getAttrib (Factor.FIELD_ZScoreWeight))).listEntry (HELPER_ZScoreWeight2.getForSQL(dummyZScoreWeight2, factor_hdrPSet.getAttrib (Factor.FIELD_ZScoreWeight2))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}factor_hdr WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "factor_hdr", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (FactorPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "factor_hdr");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:factor_hdr for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (FactorPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (FactorPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet factor_hdrPSet = allPSets.getPersistentSet(objectID, "factor_hdr");
        

        LogMgr.log (FactorPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}factor_hdr " +
                                                       "WHERE factor_hdr.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}factor_hdr WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "factor_hdr");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:factor_hdr for row:" + objectID;

                    LogMgr.log (FactorPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Factor> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Factor.REFERENCE_Factor.getObjectIDSpace (), r.getLong ("id"));
            Factor resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Factor.REFERENCE_Factor);

                if (cachedElement instanceof Factor)
                {
                    LogMgr.log (FactorPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Factor)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Factor");
                }
            }
            else
            {
                PersistentSet factor_hdrPSet = allPSets.getPersistentSet(objectID, "factor_hdr", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Factor ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (FactorPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}factor_hdr " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet factor_hdrPSet = allPSets.getPersistentSet(objectID, "factor_hdr", PersistentSetStatus.FETCHED);
        
            // Object Modified
            factor_hdrPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            factor_hdrPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        factor_hdrPSet.setAttrib(Factor.FIELD_FactorNo, HELPER_FactorNo.getFromRS(dummyFactorNo, r, "factor_number"));
        factor_hdrPSet.setAttrib(Factor.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "factor_hdr_desc"));
        factor_hdrPSet.setAttrib(Factor.FIELD_ClassCode, HELPER_ClassCode.getFromRS(dummyClassCode, r, "class_code"));
        factor_hdrPSet.setAttrib(Factor.FIELD_Notes, HELPER_Notes.getFromRS(dummyNotes, r, "factor_hdr_notes"));
        factor_hdrPSet.setAttrib(Factor.FIELD_LevelNo, HELPER_LevelNo.getFromRS(dummyLevelNo, r, "level_number"));
        factor_hdrPSet.setAttrib(Factor.FIELD_LeftAnnot, HELPER_LeftAnnot.getFromRS(dummyLeftAnnot, r, "left_annot"));
        factor_hdrPSet.setAttrib(Factor.FIELD_RightAnnot, HELPER_RightAnnot.getFromRS(dummyRightAnnot, r, "right_annot"));
        factor_hdrPSet.setAttrib(Factor.FIELD_DescriptionSchinese, HELPER_DescriptionSchinese.getFromRS(dummyDescriptionSchinese, r, "factor_hdr_desc_schinese"));
        factor_hdrPSet.setAttrib(Factor.FIELD_DescriptionChinese, HELPER_DescriptionChinese.getFromRS(dummyDescriptionChinese, r, "factor_hdr_desc_chinese"));
        factor_hdrPSet.setAttrib(Factor.FIELD_DescriptionKorean, HELPER_DescriptionKorean.getFromRS(dummyDescriptionKorean, r, "factor_hdr_desc_korean"));
        factor_hdrPSet.setAttrib(Factor.FIELD_DescriptionThai, HELPER_DescriptionThai.getFromRS(dummyDescriptionThai, r, "factor_hdr_desc_thai"));
        factor_hdrPSet.setAttrib(Factor.FIELD_ZScoreWeight, HELPER_ZScoreWeight.getFromRS(dummyZScoreWeight, r, "z_score_wght"));
        factor_hdrPSet.setAttrib(Factor.FIELD_ZScoreWeight2, HELPER_ZScoreWeight2.getFromRS(dummyZScoreWeight2, r, "z_score_wght_2"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet factor_hdrPSet = allPSets.getPersistentSet(objectID, "factor_hdr");
        

        
        if (factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}factor_hdr " +
                                     "  (factor_number, factor_hdr_desc, class_code, factor_hdr_notes, level_number, left_annot, right_annot, factor_hdr_desc_schinese, factor_hdr_desc_chinese, factor_hdr_desc_korean, factor_hdr_desc_thai, z_score_wght, z_score_wght_2,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_FactorNo.getForSQL(dummyFactorNo, factor_hdrPSet.getAttrib (Factor.FIELD_FactorNo))).listEntry (HELPER_Description.getForSQL(dummyDescription, factor_hdrPSet.getAttrib (Factor.FIELD_Description))).listEntry (HELPER_ClassCode.getForSQL(dummyClassCode, factor_hdrPSet.getAttrib (Factor.FIELD_ClassCode))).listEntry (HELPER_Notes.getForSQL(dummyNotes, factor_hdrPSet.getAttrib (Factor.FIELD_Notes))).listEntry (HELPER_LevelNo.getForSQL(dummyLevelNo, factor_hdrPSet.getAttrib (Factor.FIELD_LevelNo))).listEntry (HELPER_LeftAnnot.getForSQL(dummyLeftAnnot, factor_hdrPSet.getAttrib (Factor.FIELD_LeftAnnot))).listEntry (HELPER_RightAnnot.getForSQL(dummyRightAnnot, factor_hdrPSet.getAttrib (Factor.FIELD_RightAnnot))).listEntry (HELPER_DescriptionSchinese.getForSQL(dummyDescriptionSchinese, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionSchinese))).listEntry (HELPER_DescriptionChinese.getForSQL(dummyDescriptionChinese, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionChinese))).listEntry (HELPER_DescriptionKorean.getForSQL(dummyDescriptionKorean, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionKorean))).listEntry (HELPER_DescriptionThai.getForSQL(dummyDescriptionThai, factor_hdrPSet.getAttrib (Factor.FIELD_DescriptionThai))).listEntry (HELPER_ZScoreWeight.getForSQL(dummyZScoreWeight, factor_hdrPSet.getAttrib (Factor.FIELD_ZScoreWeight))).listEntry (HELPER_ZScoreWeight2.getForSQL(dummyZScoreWeight2, factor_hdrPSet.getAttrib (Factor.FIELD_ZScoreWeight2)))  .listEntry (objectID.longID ()).toList().toArray());

            factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
