
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class DiversityQuestionPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea DiversityQuestionPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "DiversityQuestion");

    // Private attributes corresponding to business object data
    private String dummyCode;
    private String dummyQuestionText;
    private Boolean dummyAustraliaOnly;
    private Boolean dummyMultipleAnswers;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Code = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_QuestionText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_AustraliaOnly = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MultipleAnswers = DefaultAttributeHelper.INSTANCE;
    



    public DiversityQuestionPersistenceMgr ()
    {
        dummyCode = (String)(HELPER_Code.initialise (dummyCode));
        dummyQuestionText = (String)(HELPER_QuestionText.initialise (dummyQuestionText));
        dummyAustraliaOnly = (Boolean)(HELPER_AustraliaOnly.initialise (dummyAustraliaOnly));
        dummyMultipleAnswers = (Boolean)(HELPER_MultipleAnswers.initialise (dummyMultipleAnswers));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_diversity_question.object_id as id, {PREFIX}tl_diversity_question.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_diversity_question.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_diversity_question.question_code, {PREFIX}tl_diversity_question.question_text, {PREFIX}tl_diversity_question.australia_only, {PREFIX}tl_diversity_question.multiple_answers,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, DiversityQuestion.REFERENCE_DiversityQuestion);

                if (objectToReturn instanceof DiversityQuestion)
                {
                    LogMgr.log (DiversityQuestionPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a DiversityQuestion");
                }
            }

            PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(id, "tl_diversity_question", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_diversity_questionPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_diversity_questionPSet.containsAttrib(DiversityQuestion.FIELD_Code)||
                    !tl_diversity_questionPSet.containsAttrib(DiversityQuestion.FIELD_QuestionText)||
                    !tl_diversity_questionPSet.containsAttrib(DiversityQuestion.FIELD_AustraliaOnly)||
                    !tl_diversity_questionPSet.containsAttrib(DiversityQuestion.FIELD_MultipleAnswers))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (DiversityQuestionPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                DiversityQuestion result = new DiversityQuestion ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_diversity_question " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_diversity_question.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_diversity_question");
            

            
            if (tl_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_diversity_question " +
                                                           "SET question_code = ?, question_text = ?, australia_only = ?, multiple_answers = ? , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_diversity_question.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Code.getForSQL(dummyCode, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_Code))).listEntry (HELPER_QuestionText.getForSQL(dummyQuestionText, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_QuestionText))).listEntry (HELPER_AustraliaOnly.getForSQL(dummyAustraliaOnly, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_AustraliaOnly))).listEntry (HELPER_MultipleAnswers.getForSQL(dummyMultipleAnswers, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_MultipleAnswers))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_diversity_question WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_diversity_question", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (DiversityQuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_diversity_question");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_diversity_question for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (DiversityQuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (DiversityQuestionPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_diversity_question");
        

        LogMgr.log (DiversityQuestionPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_diversity_question " +
                                                       "WHERE tl_diversity_question.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_diversity_question WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_diversity_question");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_diversity_question for row:" + objectID;

                    LogMgr.log (DiversityQuestionPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, DiversityQuestion> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (DiversityQuestion.REFERENCE_DiversityQuestion.getObjectIDSpace (), r.getLong ("id"));
            DiversityQuestion resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, DiversityQuestion.REFERENCE_DiversityQuestion);

                if (cachedElement instanceof DiversityQuestion)
                {
                    LogMgr.log (DiversityQuestionPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (DiversityQuestion)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a DiversityQuestion");
                }
            }
            else
            {
                PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_diversity_question", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new DiversityQuestion ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (DiversityQuestionPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_diversity_question " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (DiversityQuestion.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_diversity_question.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_diversity_question.object_id is not null
                    String preFilter = "(tl_diversity_question.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_diversity_question " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_diversity_question", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_diversity_questionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_diversity_questionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_diversity_questionPSet.setAttrib(DiversityQuestion.FIELD_Code, HELPER_Code.getFromRS(dummyCode, r, "question_code"));
        tl_diversity_questionPSet.setAttrib(DiversityQuestion.FIELD_QuestionText, HELPER_QuestionText.getFromRS(dummyQuestionText, r, "question_text"));
        tl_diversity_questionPSet.setAttrib(DiversityQuestion.FIELD_AustraliaOnly, HELPER_AustraliaOnly.getFromRS(dummyAustraliaOnly, r, "australia_only"));
        tl_diversity_questionPSet.setAttrib(DiversityQuestion.FIELD_MultipleAnswers, HELPER_MultipleAnswers.getFromRS(dummyMultipleAnswers, r, "multiple_answers"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_diversity_question");
        

        
        if (tl_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_diversity_question " +
                                     "  (question_code, question_text, australia_only, multiple_answers,   object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Code.getForSQL(dummyCode, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_Code))).listEntry (HELPER_QuestionText.getForSQL(dummyQuestionText, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_QuestionText))).listEntry (HELPER_AustraliaOnly.getForSQL(dummyAustraliaOnly, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_AustraliaOnly))).listEntry (HELPER_MultipleAnswers.getForSQL(dummyMultipleAnswers, tl_diversity_questionPSet.getAttrib (DiversityQuestion.FIELD_MultipleAnswers)))  .listEntry (objectID.longID ()).toList().toArray());

            tl_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
