import {browser, by, element} from 'protractor';
import {Credentials } from "../../protractor.conf";
import {CustomersPage} from "./customers.po";

export class LoginPage{
    userName = element(by.css('input[name="username"]'));
    password = element(by.css('input[name="password"]'));
    loginButton = element(by.css('button[name="_performlogin"]'));
    errorDom = element(by.css('.small_error_placeholder'));

    constructor() {
    }

    async navigateToLogin() {
        await browser.waitForAngularEnabled(false);
        await browser.driver.get(Credentials.url);
        await browser.driver.sleep(2000);
    }

    async setUsername(user) {
        expect(await this.userName.isPresent()).toBe(true, 'Username field not exist');
        await this.userName.clear();
        await this.userName.sendKeys(user);
    }

    async setPassword(password) {
        expect(await this.password.isPresent()).toBe(true, 'Password field not exist');
        await this.password.clear();
        await this.password.sendKeys(password);
    }
    async clickOnLoginButton():Promise<CustomersPage>{
        await this.loginButton.click();

        await browser.driver.sleep(2000);
        await browser.waitForAngularEnabled(true);
        return new Promise<CustomersPage>(resolve => resolve(new CustomersPage()));
    }
}