/*
 * Decompiled with CFR 0.152.
 */
package au.com.m4u.smsapi;

import au.com.m4u.smsapi.AllHostnameVerifier;
import au.com.m4u.smsapi.SmsMessage;
import au.com.m4u.smsapi.SmsMessageList;
import au.com.m4u.smsapi.SmsReply;
import au.com.m4u.smsapi.SmsReplyList;
import au.com.m4u.smsapi.X509TrustAllManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SmsInterface {
    private int _messageFormat;
    private int _responseCode;
    private String _responseMessage;
    private boolean _useMessageID;
    private BufferedReader _input;
    private BufferedWriter _output;
    private HttpURLConnection _httpConnection;
    private ArrayList<String> _serverList;
    private SmsMessageList _messageList;
    private boolean _secureMode;
    private boolean _debug = false;
    private FileWriter _debugOutput;
    private String _httpProxy = "";
    private int _proxyPort = -1;
    private String _proxyUsername = "";
    private String _proxyPassword = "";

    public SmsInterface(int n) {
        this._messageFormat = n;
        this._responseCode = -1;
        this._responseMessage = null;
        this._useMessageID = false;
        this._messageList = new SmsMessageList();
        this._serverList = null;
        this._input = null;
        this._output = null;
        this._httpConnection = null;
        this._secureMode = false;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setDebug(String string) throws IOException {
        this._debug = true;
        this._debugOutput = new FileWriter(string, true);
        Date date = new Date();
        this._debugOutput.write("\n--- Output start at " + date + " ---\n");
        this._debugOutput.flush();
    }

    public void setHttpProxy(String string, int n, String string2, String string3) {
        this._httpProxy = string;
        this._proxyPort = n;
        this._proxyUsername = string2;
        this._proxyPassword = string3;
    }

    public void setHttpProxy(String string, int n) {
        this._httpProxy = string;
        this._proxyPort = n;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseMessage() {
        return this._responseMessage;
    }

    public void addMessage(SmsMessage smsMessage) {
        this._messageList.addMessage(smsMessage);
    }

    public void addMessage(String string, String string2, long l, int n, short s, boolean bl) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                string3 = string3 + c;
                continue;
            }
            if (c != '+' || string3.length() != 0) continue;
            string3 = string3 + c;
        }
        this.addMessage(new SmsMessage(string3, string2, l, n, s, bl));
    }

    public void clearMessages() {
        this._messageList.clear();
    }

    private boolean openServerConnection(String string) {
        Proxy proxy = Proxy.NO_PROXY;
        try {
            if (this._httpProxy != "") {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._httpProxy, this._proxyPort));
                if (this._proxyUsername != "" && this._proxyPassword != "") {
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(SmsInterface.this._proxyUsername, SmsInterface.this._proxyPassword.toCharArray());
                            return passwordAuthentication;
                        }
                    });
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Could not configure HTTP proxy - " + illegalArgumentException.getMessage());
            return false;
        }
        catch (SecurityException securityException) {
            System.err.println("Could not configure HTTP proxy Authentication - " + securityException.getMessage());
            return false;
        }
        try {
            if (this._secureMode) {
                URL uRL = new URL("https://" + string);
                this._httpConnection = (HttpsURLConnection)uRL.openConnection(proxy);
            } else {
                URL uRL = new URL("http://" + string);
                this._httpConnection = (HttpURLConnection)uRL.openConnection(proxy);
            }
            this._httpConnection.setDoOutput(true);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad server address '" + string + "'");
            return false;
        }
        catch (IOException iOException) {
            this._httpConnection = null;
            System.err.println("Could not open connection to " + string + " - " + iOException.getMessage());
            return false;
        }
        if (this._secureMode) {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustAllManager()};
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, trustManagerArray, null);
                ((HttpsURLConnection)this._httpConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this._httpConnection.disconnect();
                this._httpConnection = null;
                System.err.println("Could not get SSL instance - " + noSuchAlgorithmException.getMessage());
                return false;
            }
            catch (KeyManagementException keyManagementException) {
                this._httpConnection.disconnect();
                this._httpConnection = null;
                System.err.println("Could not initialize SSL context - " + keyManagementException.getMessage());
                return false;
            }
            ((HttpsURLConnection)this._httpConnection).setHostnameVerifier(new AllHostnameVerifier());
        }
        try {
            this._output = new BufferedWriter(new OutputStreamWriter(this._httpConnection.getOutputStream()));
            this._httpConnection.connect();
        }
        catch (IOException iOException) {
            this._httpConnection.disconnect();
            this._httpConnection = null;
            this._output = null;
            System.err.println("Could not connect to " + string + " - " + iOException.getMessage());
            return false;
        }
        return true;
    }

    private boolean openInputConnection() {
        if (this._input != null) {
            return true;
        }
        try {
            this._output.flush();
            this._input = new BufferedReader(new InputStreamReader(this._httpConnection.getInputStream()));
        }
        catch (IOException iOException) {
            System.err.println("Could not read from server - " + iOException.getMessage());
            return false;
        }
        try {
            String string = this._input.readLine();
            if (string == null) {
                System.err.println("Null response from server");
                return false;
            }
            if (!string.startsWith("<HTML><HEAD><TITLE>M4U")) {
                System.err.println("Not an M4U server");
                return false;
            }
            string = this._input.readLine();
            if (string == null) {
                System.err.println("Null body response from server");
                return false;
            }
            if (!string.startsWith("<BODY>")) {
                System.err.println("Not an M4U body response");
                return false;
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not read from server - " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public boolean connect(String string, String string2, boolean bl) {
        if (this._httpConnection != null) {
            return false;
        }
        this._serverList = new ArrayList();
        this._serverList.add("smsmaster.m4u.com.au");
        this._serverList.add("smsmaster1.m4u.com.au");
        this._serverList.add("smsmaster2.m4u.com.au");
        this._useMessageID = bl;
        for (int i = 0; i < this._serverList.size() && !this.openServerConnection(this._serverList.get(i)); ++i) {
        }
        if (this._httpConnection == null) {
            return false;
        }
        try {
            this.writeToConnection("m4u\r\n");
            if (bl) {
                this.writeToConnection("USER=" + string + "#\r\n");
            } else {
                this.writeToConnection("USER=" + string + "\r\n");
            }
            this.writeToConnection("PASSWORD=" + string2 + "\r\n");
        }
        catch (IOException iOException) {
            this.close();
            System.err.println("Error when writing to the server - " + iOException.getMessage());
            return false;
        }
        return true;
    }

    private void writeToConnection(String string) throws IOException {
        if (this._debug) {
            try {
                this._debugOutput.write(string);
                this._debugOutput.flush();
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                System.err.print(string);
            }
        }
        this._output.write(string);
    }

    private void close() {
        if (this._httpConnection == null) {
            return;
        }
        try {
            if (this._output != null) {
                this._output.flush();
                this._output.close();
            }
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._httpConnection.disconnect();
        this._httpConnection = null;
        this._input = null;
        this._output = null;
    }

    private int readResponseCode() {
        int n;
        String string;
        try {
            string = this._input.readLine();
            if (string == null) {
                return 600;
            }
        }
        catch (IOException iOException) {
            return 600;
        }
        try {
            this._responseCode = n = Integer.parseInt(string.substring(0, 3));
            this._responseMessage = string.substring(4);
        }
        catch (NumberFormatException numberFormatException) {
            n = 700;
        }
        return n;
    }

    public boolean changePassword(String string) {
        if (this._httpConnection == null) {
            return false;
        }
        boolean bl = true;
        try {
            this.writeToConnection("NEWPASSWORD=" + string + "\r\n");
            this.writeToConnection("MESSAGES\r\n");
            this.writeToConnection(".\r\n");
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl && (!this.openInputConnection() || this.readResponseCode() / 100 != 1)) {
            bl = false;
        }
        this.close();
        return bl;
    }

    public SmsReplyList checkReplies() {
        int n;
        if (this._httpConnection == null) {
            return null;
        }
        try {
            this.writeToConnection("CHECKREPLY\r\n");
            this.writeToConnection(".\r\n");
        }
        catch (IOException iOException) {
            this.close();
            return null;
        }
        if (!this.openInputConnection() || (n = this.readResponseCode()) != 150) {
            this.close();
            return null;
        }
        SmsReplyList smsReplyList = new SmsReplyList();
        try {
            String string;
            while ((string = this._input.readLine()) != null && !string.startsWith(".")) {
                SmsReply smsReply = SmsReply.parse(string, this._useMessageID);
                if (smsReply == null) continue;
                smsReplyList.addReply(smsReply);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
        return smsReplyList;
    }

    public int getCreditsRemaining() {
        String string;
        if (this._httpConnection == null) {
            return -2;
        }
        try {
            this.writeToConnection("MESSAGES\r\n");
            this.writeToConnection(".\r\n");
            if (!this.openInputConnection()) {
                this.close();
                return -2;
            }
            string = this._input.readLine();
        }
        catch (IOException iOException) {
            this.close();
            return -2;
        }
        this.close();
        if (string == null) {
            return -2;
        }
        try {
            int n;
            this._responseCode = n = Integer.parseInt(string.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            return -2;
        }
        if (this._responseCode != 100 && this._responseCode != 120) {
            return -2;
        }
        String string2 = string.substring(7);
        int n = string2.indexOf(32);
        if (n < 0) {
            return -2;
        }
        try {
            return Integer.parseInt(string2.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return -2;
        }
    }

    public boolean sendMessages() {
        if (this._httpConnection == null) {
            return false;
        }
        boolean bl = true;
        try {
            if (this._messageFormat >= 2) {
                this.writeToConnection("MESSAGES2.0\r\n");
            } else {
                this.writeToConnection("MESSAGES\r\n");
            }
            for (int i = 0; i < this._messageList.size(); ++i) {
                SmsMessage smsMessage = this._messageList.getMessage(i);
                this.writeToConnection(smsMessage.getMessageID() + " " + smsMessage.getPhoneNumber() + " " + smsMessage.getDelay() + " ");
                if (this._messageFormat >= 2) {
                    this.writeToConnection(smsMessage.getValidityPeriod() + " " + (smsMessage.getDeliveryReportRequest() ? (char)'1' : '0') + " ");
                }
                this.writeToConnection(smsMessage.getMessage(true) + "\r\n");
            }
            this.writeToConnection(".\r\n");
        }
        catch (IOException iOException) {
            System.err.println("Failed to write messages to server - " + iOException.getMessage());
            bl = false;
        }
        if (bl && (!this.openInputConnection() || this.readResponseCode() / 100 != 1)) {
            bl = false;
        }
        this.close();
        return bl;
    }

    public static boolean internetConnected() {
        return SmsInterface.internetConnected("http://www.google.com");
    }

    public static boolean internetConnected(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                httpURLConnection.disconnect();
                return false;
            }
            InputStream inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return false;
        }
        httpURLConnection.disconnect();
        return true;
    }

    public void useSecureMode(boolean bl) {
        this._secureMode = bl;
    }
}

