<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         =   process.getTransaction ();
    Job                 job             =   (Job) process.getAttribute("Job");
    Candidate           candidate       =   (Candidate) process.getAttribute("NewCandidate");
    SecUser             secUser         =   null;
    boolean             toRedirect      =   false;

    String      id          =   request.getParameter("id");
    String      key         =   request.getParameter("key");
    String      candidateId =   request.getParameter("aid");
    String      pin         =   request.getParameter("pin");
    Boolean     isVerify    =   Boolean.FALSE;
    
    if(id != null || key != null || candidateId != null || pin != null)
    {
        isVerify    =   Boolean.TRUE;

        if(candidateId != null && pin != null)
        {
            candidate   =   Candidate.searchIdPin(transaction, Long.parseLong(candidateId), pin);

            if(candidate != null && candidate.getIsAccountVerified() != Boolean.TRUE)
            {
                secUser =   candidate.getUser();
                process.setAttribute("NewCandidate", candidate);
            }
        }
        
        if(id != null && key != null)
        {
            job = Job.searchJobKey(transaction, Long.parseLong(id), key);
            process.setAttribute("Job", job);
        }
    }
    else
    {
        toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    }

    //INVALID REQUEST FOR VERIFY CANDIDATE
    if(isVerify && (job == null || secUser == null))
    {
        response.sendRedirect(WebUtils.getSamePageInRenderMode(request, "AuthError"));
        return;     //Else it will continue execution and throws NPE.
    }
    
    if(secUser == null)
    {
        secUser     =   SecUser.getTXUser(transaction);
        candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    }
    
    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");

    JobApplication  jobApplication  =   JobApplication.searchCandidateJob(transaction, candidate, job);
    Article         applyJobArticle =   WebUtils.getArticleByShortCut(objTran, WebUtils.JOB_APPLICATION);
    String          nextPage        =   applyJobArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "SelectionCriteria").toMap());
    
    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }

    candidate.setPrivacyPolicyAgreed(Boolean.TRUE);
    candidate.setConditionsAgreed(Boolean.TRUE);

    process.setAttribute("JobApplication", jobApplication);
    process.setAttribute("JobApplicationID", jobApplication.getID().longID());

    Set<String> attribsToRestore    =   new HashSet<>();
    attribsToRestore.add("JobApplication");
    
%>
 
<style>
    .pwd-verify-identity .second-style {
        font-size: 14px;
        /*line-height: 40px;*/
    }
    
    .pl-verify {margin: 8.3% auto 9px !important}
    
    body {background-color: #e9ecef !important}
</style>
        
    <div class="apply-job-logo-header signinpage">
        <div>
            <div class="logo-img">
            <%
                BinaryContent   logo    =   job.getLogo();

                if(logo != null)
                {
                    int logoHeight  =   45;
            %>
                    <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
            <%
                }
            %>
            </div>
            <div class="header-title">
                <%= job.getTeamName() %>
            </div>
        </div>
    </div>
    <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="pwd-verify-identity">
            <div class="pl-verify">Please enter your password to continue your application</div>
            <%
                if(isVerify)
                {
            %>
            <div id="overlay">
                <div class="modal-dialog">
                    <div class="modal-body main-password-popup">
                        <div class="form-group text-left pwd-box">
                            <label class="pwd-label">Password</label>
                            <oneit:ormInput obj="<%= job %>"    type="password" attributeName="Password"    cssClass="form-control second-style pwd-input-box" autofocus="true"/>
                        </div>
                        <div class="create-y-f-job">
                            <oneit:button   value="Verify and proceed"   name="verifyIdentity"   cssClass="box-btn   verify-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry("Job",job)
                                                                    .mapEntry("Candidate",candidate)
                                                                    .mapEntry("JobApplication",jobApplication)
                                                                    .mapEntry("isVerify",Boolean.TRUE)
                                                                    .mapEntry("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("attribNamesToRestore", attribsToRestore)
                                                                    .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                    .toMap() %>"/>

                        </div>
                    </div>          
                </div>
            </div>
            <%  }   %>
        </div>
    </oneit:form>
    
</oneit:dynIncluded>